from flask_restful import Resource, reqparse
from flask import session
from peewee import fn
from median.models import Adresse, Stock, Historique, Gpao, Magasin
import datetime
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('ref')
parser.add_argument('quantite_new')
parser.add_argument('fraction')
parser.add_argument('quantite_old')
parser.add_argument('service')
parser.add_argument('adresse')
parser.add_argument('pk')
parser.add_argument('lot_old')
parser.add_argument('date_peremption_old')
parser.add_argument('contenant')
parser.add_argument('ucd')


class ApiSortieUnitaire(Resource):

    def post(self, ref):

        logger.info("Sortie unitaire d'un produit : " + ref)

        args = parser.parse_args()
        quantite_prelevee = int(args['quantite_new'])
        _fraction = args['fraction']
        quantite_old = int(args['quantite_old'])
        _serv = args['service']
        _adr = self._padAddressField(args['adresse'])
        _pk = args['pk']
        _lot_o = args['lot_old']
        _dp_o = args['date_peremption_old']
        _contenant = args['contenant']
        _ucd = args['ucd']

        # si il y a des incohérences au niveau du stock, on demande de faire une mise au point d'abord
        if quantite_prelevee > quantite_old:
            return "Vous ne pouvez pas cueillir plus de " + str(quantite_old) + " comprimés à cet emplacement !"

        # on modifie la quantité de stock à cet emplacement, et on fait un mouvement GPAO pour ce service
        _qte_o = quantite_old
        _qte_n = quantite_old - quantite_prelevee
        try:
            self._put_new_quantite(_pk, _adr, ref, int(_qte_n), int(_qte_o), _lot_o,
                                   _dp_o, _contenant, _ucd, _fraction, _serv)

        except Exception as error:
            logger.error(error.args)
            return error.args, 503

        logger.info('Sortie unitaire d\'un produit... REUSSI')
        return 'Success'

    def _padAddressField(self, adr):

        _adr_items = adr.split('.')
        _o = []
        for a in _adr_items:
            _o.append(a.rjust(3))
        return '.'.join(_o)

    def _put_new_quantite(self, pk, adresse, ref, quantite_new, quantite_old,
                          lot, peremp, contenant, ucd, fraction, service):

        logger.info('Edition de la quantité d\'une ligne de stock...')

        _diff = quantite_old - quantite_new

        if (_diff == 0):
            logger.debug('Nouvelle quantité = 0, donc on ne fait rien')
            return
        else:
            # logger.debug('Edition de la quantité associée à une ligne de stock, pk: "%s",'
            #              ' qté: "%s"' % (pk, quantite_new))
            # Stock.update({Stock.quantite: quantite_new}).where((Stock.pk == pk)).execute()

            if (quantite_new == 0):
                logger.debug('Suppression de la ligne de stock...')
                (Stock.delete().where(Stock.pk == pk).execute())

                nb_lignes_stocks = (Stock.select(Stock.quantite).where(Stock.adresse == adresse))

                if nb_lignes_stocks.count() == 0:
                    logger.debug('Mise à jour de l\'adresse, celle-ci devient libre: "%s"' % (adresse))
                    Adresse.update({Adresse.etat: 'L'}).where(Adresse.adresse == adresse).execute()
            else:
                logger.debug('Edition de la quantité associée à une ligne de stock, pk: "%s",'
                             ' qté: "%s"' % (pk, quantite_new))

            Stock.update({Stock.quantite: quantite_new}).where((Stock.pk == pk)).execute()
            logger.debug('Edition de la quantité associée à une ligne de stock, pk: "%s",'
                         ' qté: "%s"' % (pk, quantite_new))
            Stock.update({Stock.quantite: quantite_new}).where((Stock.pk == pk)).execute()

        qte_tot = (Stock.select(fn.SUM(Stock.quantite)).where(Stock.reference == ref))

        nb_lignes_stocks = Stock.select(Stock.quantite).where(Stock.adresse == adresse)

        if nb_lignes_stocks.count() == 0:
            logger.debug('Mise à jour de l\'adresse, celle-ci devient libre: "%s"' % (adresse))
            Adresse.update({Adresse.etat: 'L'}).where(Adresse.adresse == adresse).execute()

        logger.debug('Ecriture dans la table historique')
        Historique.create(
            chrono=datetime.datetime.now(),
            reference=ref,
            adresse=adresse,
            quantite_mouvement=_diff,
            quantite_totale=qte_tot,
            service=service,
            type_mouvement='SOR',
            lot=lot,
            pmp=0,
            date_peremption=peremp,
            contenant=contenant,
            poste='MEDIAN_CL',
            ucd=ucd,
            fraction=fraction,
            utilisateur=session['username']
        )

        _calc_id_robot = (Magasin.select(Magasin.id_robot).where(Magasin.mag == adresse[0:3]))
        _id_robot = _calc_id_robot[0].id_robot or 1

        logger.info('GPAO: Ajout d\'un mouvement de type sortie')
        Gpao.create(
            chrono=datetime.datetime.now(),
            etat='A',
            ref=ref,
            qte=_diff,
            lot=lot,
            type_mvt='S',
            dest=service,
            tperemp=peremp,
            fraction=fraction,
            id_robot=_id_robot
        )

        logger.info('Edition de la quantité d\'une ligne de stock... REUSSI')
