from flask_restful import Resource, reqparse
from peewee import DoesNotExist
from median.models import Magasin, FListe, FItem, Product, Service
from median.constant import TypeServiListe, TypeListe, EtatListe
from common.status import HTTP_400_BAD_REQUEST
import datetime
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('poste', required=True)
parser.add_argument('service', required=True)
parser.add_argument('quantite', required=True, type=int)


class ApiSortieGlobale(Resource):

    def get(self, ref):
        return {'message': 'Use POST request!'}, HTTP_400_BAD_REQUEST

    def post(self, ref):

        logger.info("Sortie globale d'un produit : " + ref)

        args = parser.parse_args()
        quantite_prelevee = args['quantite']
        poste = args['poste']
        service = args['service']

        # Verify is product exists, if not return 404
        try:
            Product.get(reference=ref)
        except DoesNotExist:
            return {'message': 'Product %s does not exists' % ref}, 404

        try:
            mag = Magasin.get(type_mag=poste)
            type_servi = TypeServiListe.GlobaleBoite.value
            if mag.eco_type == 'L':
                type_servi = TypeServiListe.RiedlBoite.value
        except DoesNotExist:
            return {'message': 'Warehouse relate to poste %s does not exists' % poste}, 404

        try:
            Service.get(code=service, type_dest='SERVICE')
        except DoesNotExist:
            return {'message': 'Service %s does not exists' % service}, 404

        liste_name = '%s-GLOBALE-%s' % (service, mag.mag)
        number_item = 1
        try:
            lst = FListe.get(liste=liste_name, mode="S", zone_deb="RIEDL")
            number_item = lst.nb_item + 1
            lst.nb_item = number_item
            lst.type_servi = type_servi
            lst.date_modification = datetime.datetime.now()
            lst.save()
        except DoesNotExist:
            lst = FListe()
            lst.liste = liste_name
            lst.mode = TypeListe.Output.value
            lst.etat = EtatListe.Vierge.value
            lst.zone_deb = 'RIEDL'
            lst.zone_fin = poste
            lst.fusion = "SORTIE GLOBALE"
            lst.num_sej = "GLOBALE"
            lst.ipp = ""
            lst.num_ipp = ""
            lst.service = service
            lst.type_servi = type_servi
            lst.no_pilulier = 1
            lst.pos_pilulier = 3
            lst.nb_item = 1
            lst.save()

        itm = FItem()
        itm.liste = lst.liste
        itm.mode = lst.mode
        itm.etat = EtatListe.Vierge.value
        itm.dest = lst.service
        itm.num_ipp = ""
        itm.num_sej = "GLOBALE"
        itm.reference = ref
        itm.qte_dem = quantite_prelevee
        itm.qte_serv = 0
        itm.fraction = 100
        itm.type_servi = lst.type_servi
        itm.item = str(number_item).zfill(6)
        itm.dtprise = datetime.datetime.now()
        itm.save()

        return {'result': "ok", 'id': lst.pk}
