from flask_restful import Resource
from median.models import Dispensation, Service
import logging

logger = logging.getLogger('median.webserver')


class ApiServicesWithDispensations(Resource):

    def get(self):

        try:
            services = (Service.select(Service.code, Service.libelle)
                        .join(Dispensation, on=(Dispensation.service == Service.code))
                        .where(Dispensation.mode == 'S')
                        .group_by(Dispensation.service)
                        .order_by(Service.libelle))

        except Exception as error:
            return {'message': error.args}, 503

        logger.info('Lines : %s.' % len(services))

        return ([{
            'id': s.code,
            'name': s.libelle
        } for s in services])
