from flask_restful import Resource
from flask_restful import reqparse
from median.models import Service, Historique
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('fonction')
parser.add_argument('code')
parser.add_argument('libelle')
parser.add_argument('type_peigne')
parser.add_argument('moment_deb')
parser.add_argument('deb_matin')
parser.add_argument('deb_midi')
parser.add_argument('deb_soir')
parser.add_argument('deb_coucher')
parser.add_argument('tri')


class ApiServices(Resource):

    def get(self):

        args = parser.parse_args()
        v_fonction = args['fonction']

        try:
            if v_fonction == '1':
                services = (Service.select(
                    Service.code, Service.libelle).distinct()
                    .join(Historique, on=(Service.code == Historique.service)).where(
                        Service.type_dest == 'SERVICE').order_by(Service.code))
            else:
                services = (Service.select(Service.code, Service.libelle).where(
                    Service.type_dest == 'SERVICE').order_by(Service.code))

        except Exception as error:
            return {'message': error.args}, 503

        logger.info('Lines : %s.' % len(services))
        logger.info(v_fonction)

        return ([{
            'id': s.code,
            'name': s.libelle,
            'code_et_name': s.code + "-" + s.libelle
        } for s in services])

    def put(self):

        args = parser.parse_args()
        v_code = args['code']
        v_libelle = args['libelle']
        v_type_peigne = args['type_peigne']
        v_moment_deb = args['moment_deb']
        v_deb_matin = args['deb_matin']
        v_deb_midi = args['deb_midi']
        v_deb_soir = args['deb_soir']
        v_deb_coucher = args['deb_coucher']
        v_tri = args['tri']

        Service.update(
            code=v_code, libelle=v_libelle, type_peigne=v_type_peigne, moment_deb=v_moment_deb,
            deb_matin=v_deb_matin, deb_midi=v_deb_midi, deb_soir=v_deb_soir, deb_coucher=v_deb_coucher,
            tri=v_tri).where(Service.code == v_code, Service.type_dest == 'SERVICE').execute()

    def post(self):

        args = parser.parse_args()
        v_code = args['code']
        v_libelle = args['libelle']
        v_type_peigne = args['type_peigne']
        v_moment_deb = args['moment_deb']
        v_deb_matin = args['deb_matin']
        v_deb_midi = args['deb_midi']
        v_deb_soir = args['deb_soir']
        v_deb_coucher = args['deb_coucher']
        v_tri = args['tri']

        nb_service = Service.select().where(Service.code == v_code).count()

        if nb_service > 0:
            return {'message': 'Service déjà existant'}, 404

        Service.create(
            code=v_code, libelle=v_libelle, type_peigne=v_type_peigne, moment_deb=v_moment_deb,
            deb_matin=v_deb_matin, deb_midi=v_deb_midi, deb_soir=v_deb_soir, deb_coucher=v_deb_coucher,
            tri=v_tri, type_dest='SERVICE'
        )

    def delete(self):

        args = parser.parse_args()
        v_code = args['code']

        Service.delete().where(Service.code == v_code, Service.type_dest == 'SERVICE').execute()
