from flask_restful import Resource, reqparse
# from flask import session
from median.models import FListe, Magasin
from median.constant import TypeListe, TypeServiListe
# from median.views import RawConfig
from common.util import logger
# from peewee import DoesNotExist
# import datetime
# from datetime import date
# from datetime import timedelta

parser = reqparse.RequestParser()
parser.add_argument('pk')
parser.add_argument('ipp')
parser.add_argument('mag')
parser.add_argument('type_mag')
parser.add_argument('date_peremption')
parser.add_argument('service')
parser.add_argument('ref')
parser.add_argument('quantite')
parser.add_argument('fraction')
parser.add_argument('mode')


class ApiRiedlListesEntrees(Resource):

    def get(self):
        logger.info("Récupérer les listes d'entrees")
        return {
            'listes': self._getRiedlEntryListJSON(),
        }

    def _getRiedlEntryListJSON(self):
        res = []
        # First we search all entry list not affected to a riedl
        res.append({
            'text': '<b>Rangement</b>',
            'id': 'stdloading',
            'children': self._getRiedlRangementList(),
        })
        res.append({
            'text': '<b>Prélèvement</b>',
            'id': 'takingmode',
            'children': self._getRiedlPrelevementList(),
        })
        res.append({
            'text': '<b>Retour</b>',
            'id': 'return',
            'children': self._getRiedlRetourList(),
        })
        return res

    def _getRiedlRetourList(self):
        """List of retour from riedl"""
        res = []
        mags = Magasin.select(Magasin).where(Magasin.eco_type == 'L')
        for m in mags:
            ul = {
                'text': '<b>%s</b>' % m.libelle,
                'id': 'retour-%i' % (m.pk,),
                'children': []
            }
            # Search all lists affect to this riedl
            rdl_list = FListe.select(FListe).where(
                FListe.mode == TypeListe.Input.value,
                FListe.type_servi == TypeServiListe.Retour.value,
                FListe.zone_deb == 'RIEDL', FListe.zone_fin == m.type_mag)
            print(rdl_list)
            for lst in rdl_list:
                li = {
                    'text': '%s' % (lst.liste,),
                    'id': 'model-%s' % (lst.liste,)
                }
                ul['children'].append(li)
            res.append(ul)
        return res

    def _getRiedlPrelevementList(self,):
        """Retrieve all taking mode """
        res = []
        mags = Magasin.select(Magasin).where(Magasin.eco_type == 'L')
        for m in mags:
            ul = {
                'text': '<b>%s</b>' % m.libelle,
                'id': 'prelev-%i' % (m.pk,),
                'children': []
            }
            # Search all lists affect to this riedl
            rdl_list = FListe.select(FListe).where(
                FListe.mode == TypeListe.Input.value,
                FListe.type_servi == TypeServiListe.Prelevement.value,
                FListe.zone_deb == 'RIEDL', FListe.zone_fin == m.type_mag)
            print(rdl_list)
            for lst in rdl_list:
                li = {
                    'text': '%s' % (lst.liste,),
                    'id': 'model-%s' % (lst.liste,)
                }
                ul['children'].append(li)
            res.append(ul)
        return res

    def _getRiedlRangementList(self,):
        """Retrieve all standard loading list"""
        res = []
        ul = {
            'text': '<b>Non affectées</b>',
            'id': 'unaffected',
            'children': []
        }
        rdl_list = FListe.select(FListe).where(
                FListe.mode == TypeListe.Input.value,
                FListe.type_servi == TypeServiListe.GlobaleBoite.value,
                FListe.zone_deb == 'RIEDL', FListe.zone_fin == '')
        for lst in rdl_list:
            li = {
                'text': '%s' % (lst.liste,),
                'id': 'model-%s' % (lst.liste,)
            }
            ul['children'].append(li)
        res.append(ul)
        # Search list per riedl
        mags = Magasin.select(Magasin).where(Magasin.eco_type == 'L')
        for m in mags:
            ul = {
                'text': '<b>%s</b>' % m.libelle,
                'id': 'range-%i' % (m.pk,),
                'children': []
            }
            # Search all lists affect to this riedl
            rdl_list = FListe.select(FListe).where(
                FListe.mode == TypeListe.Input.value,
                FListe.type_servi == TypeServiListe.GlobaleBoite.value,
                FListe.zone_deb == 'RIEDL', FListe.zone_fin == m.type_mag)
            print(rdl_list)
            for lst in rdl_list:
                li = {
                    'text': '%s' % (lst.liste,),
                    'id': 'model-%s' % (lst.liste,)
                }
                ul['children'].append(li)
            res.append(ul)
        return res
