from flask_restful import Resource
from common.status import HTTP_404_NOT_FOUND
from pathlib import Path
import os
import datetime
import logging

logger = logging.getLogger('median.webserver')
cr_folder = os.environ.get('REPORTING_FOLDER', '.')


class ApiReporting(Resource):
    """
    Reporting API
    """

    def get(self, ressource=None):
        """
        Retrieve the liste of the PDF file, group by date
        """
        result = {}
        p = Path(cr_folder)
        if not p.exists():
            return {
                'message': 'Folder does not exists!',
                'folder': cr_folder,
            }, HTTP_404_NOT_FOUND

        nb_files = 0
        for f in p.glob('*.pdf'):
            dtf = datetime.datetime.fromtimestamp(f.stat().st_mtime).strftime('%Y-%m-%d')
            if dtf not in result:
                result[dtf] = []
            result[dtf].append('/download/%s' % f.name)
            nb_files += 1

        if nb_files > 0:
            return result

        return {
            'message': 'No files available!',
            'folder': cr_folder,
        }, HTTP_404_NOT_FOUND
