from flask_restful import Resource, reqparse
from median.models import Product
from peewee import DoesNotExist
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Start parameter for Datatables')
parser.add_argument('length', type=int, help='Limit parameter for Datatables')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument('search[value]', help='Ord parameter for Datatables')


class DataTables(Resource):
    def render(self, datas, draw, recordsTotal, recordsFiltered):
        return {
            'draw': draw,
            'recordsTotal': recordsTotal,
            'recordsFiltered': recordsFiltered,
            'data': datas
        }


class ApiProducts(DataTables):

    def post(self):
        args = parser.parse_args()
        v_draw = args['draw']
        v_start = args['start']
        v_length = args['length']
        v_search = args['search[value]']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']

        try:
            total_products_count = (Product
                                    .select(Product.pk,
                                            Product.reference,
                                            Product.designation,
                                            Product.ucd)
                                    .count())

            filt_prod_q = Product.select()

            if v_search:
                filt_prod_q = (filt_prod_q
                               .where(Product.reference.contains(v_search) |
                                      Product.designation.contains(v_search) |
                                      Product.ucd.contains(v_search)))

            d_order = {
                0: Product.reference,
                1: Product.designation,
                2: Product.ucd
            }
            v_orderby_column = d_order[v_orderby]

            v_orderby_column_dir = v_orderby_column
            if (v_dir == 'desc'):
                v_orderby_column_dir = v_orderby_column.desc()

            filtered_products = filt_prod_q.order_by(v_orderby_column_dir)

            paged_products = filtered_products.limit(v_length).offset(v_start)
            logger.info('Lines : %s.' % len(paged_products))

        except DoesNotExist:
            return {'message': 'Product does not exist'}, 404
        except Exception as error:
            return {'message': error.args}, 503

        return self.render([{
            'reference': p.reference,
            'ucd': p.ucd,
            'designation': ('<a href="/reference.html?' +
                            str(p.reference) + '">' + p.designation + '</a>'),
        } for p in paged_products],
         v_draw,
         total_products_count,
         filtered_products.count())
