from flask_restful import reqparse
# from flask import session
from common.rest import DataTables
from common.util import logger
from median.models import Stock, LotRetire, Ucd
from peewee import DoesNotExist, fn, ProgrammingError


parser = reqparse.RequestParser()
parser.add_argument('product_ref')
parser.add_argument('select')
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Start parameter for Datatables')
parser.add_argument('length', type=int, help='Limit parameter for Datatables')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument('ucd')
parser.add_argument('lot')
parser.add_argument('cip')
parser.add_argument('quantite')


class ApiLotsRetires(DataTables):

    def post(self, ref):
        args = parser.parse_args()
        _ucd = args['ucd']
        _lot = args['lot']

        logger.info('Création d\'une ligne Lot Retiré, lot: "%s"' % (_lot))

        try:
            LotRetire.create(ucd=_ucd, lot=_lot)

        except Exception as error:
            logger.error(error.args)
            return error.args, 503

        logger.info('Création réussie d\'une ligne Lot Retiré, lot: "%s"' % (_lot))
        return 'Success'

    def delete(self, ref):
        args = parser.parse_args()
        _ucd = args['ucd']
        _lot = args['lot']

        logger.info('Suppression d\'une ligne Lot Retiré, lot: "%s"' % (_lot))

        try:
            LotRetire.delete().where((LotRetire.ucd == _ucd) & (LotRetire.lot == _lot)).execute()

        except Exception as error:
            logger.error(error.args)
            return error.args, 503

        logger.info('Suppression réussie d\'une ligne Lot Retiré, lot: "%s"' % (_lot))
        return 'Success'

    def get(self, ref):
        args = parser.parse_args()
        v_draw = args['draw']

        try:
            total_lots_retires_count = (
                LotRetire.select()
                .join(Ucd, on=(Ucd.ucd == LotRetire.ucd))
                .where(Ucd.reference == ref)
                .count())
            filtered_lots_retires_query = (
                LotRetire.select()
                .join(Ucd, on=(Ucd.ucd == LotRetire.ucd))
                .where(Ucd.reference == ref))

            logger.debug('Lines : %s.' % len(filtered_lots_retires_query))

            return self.render([{
                'pk': s.pk,
                'ucd': s.ucd,
                'lot': s.lot,
                'quantite': self._get_quantite(ref, s.ucd, s.lot)
            } for s in filtered_lots_retires_query],
                v_draw,
                total_lots_retires_count,
                filtered_lots_retires_query.count())

        except DoesNotExist:
            logger.error('Get LotRetire raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except ProgrammingError:
            logger.error('Get LotRetire raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error('Get LotRetire raised an exception: ', error.args)
            return self.render([], v_draw, 0, 0, error.args)

    def _get_quantite(self, ref, ucd, lot):
        _q = (
            Stock.select(fn.SUM(Stock.quantite).alias('qte'))
                 .where((Stock.reference == ref) & (Stock.ucd == ucd) & (Stock.lot == lot)))
        return _q[0].qte or 0
