from flask_restful import Resource
from median.models import Stock
import logging

logger = logging.getLogger('median.webserver')


class ApiLot(Resource):

    def get(self, ucd):

        try:
            _lot = (Stock.select(Stock.lot).where(Stock.ucd == ucd).order_by(Stock.date_entree))
            logger.info('Lines : %s.' % len(_lot))
            if _lot:
                return _lot[0].lot
            else:
                return {'message': 'Lot for UCD %s not found' % ucd}, 404

        except Exception as error:
            logger.error('Exception at ApiLot.get() for ucd: %s. Details : %s' % (ucd, error.args))
            return {'message': 'Erreur serveur'}, 503
