from flask_restful import Resource, reqparse, request
# from flask import session
from median.models import FListe, FItem, Patient, Stock, Product, Prescription
from median.constant import TypeServiListe
from median.views import RawConfig
from common.util import logger
from peewee import DoesNotExist
import datetime
from datetime import date
from datetime import timedelta

parser = reqparse.RequestParser()
parser.add_argument('pk')
parser.add_argument('ipp')
parser.add_argument('mag')
parser.add_argument('type_mag')
parser.add_argument('date_peremption')
parser.add_argument('service')
parser.add_argument('ref')
parser.add_argument('quantite')
parser.add_argument('fraction')
parser.add_argument('mode')


class ApiListesSorties(Resource):

    def get(self):
        args = parser.parse_args()
        _ipp = args['ipp']
        logger.info("Récupérer les listes de sorties...")
        ucd_cip_list = self._getProductUCDAndCIPListJSON(_ipp)
        # logger.info('Récupérer les listes de sorties... %s' % ucd_cip_list.count())
        return {
               'ucd_cip_list': ucd_cip_list
        }

    def delete(self):
        args = parser.parse_args()
        _pk = args['pk']
        logger.info("Suppression d'une liste de sorties: %s" % _pk)

        try:

            # get list label (needed to fetch items)
            _l = FListe.select(FListe.liste).where(FListe.liste == _pk)

            if len(_l) == 0:
                logger.error("Liste de sorties non trouvée: %s" % _pk)
                return {'message': "Liste de sorties non trouvée!"}, 503

            FItem.delete().where((FItem.liste == _l[0].liste) & (FItem.mode == 'S')).execute()
            FListe.delete().where((FListe.liste == _pk) & (FListe.mode == 'S')).execute()

            logger.info("Suppression réussie d'une liste de sorties: %s" % _pk)
            return {'message': 'Success', 'id': None}

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

    def _getProductUCDAndCIPListJSON(self, _ipp):
        _out = []

        if _ipp:
            logger.info("IPP: %s" % _ipp)
            ucd_list = (FListe.select(FListe.service, FListe.fusion).join(Patient, on=(
                FListe.ipp == Patient.ipp).alias('scan_obj')).distinct().where(
                    (FListe.mode == 'S') & (FListe.ipp.contains(_ipp) | Patient.nom.contains(_ipp) | Patient.prenom.contains(_ipp))))  # noqa
        else:
            logger.info("Sans IPP:")
            ucd_list = (FListe.select(FListe.service, FListe.fusion).join(Patient, on=(
                FListe.ipp == Patient.ipp).alias('scan_obj')).distinct().where(
                    (FListe.mode == 'S')))  # noqa

        for u in ucd_list:
            ucd_cip_list = (FListe.select(FListe.pk, FListe.liste, FListe.service, Patient.nom, Patient.prenom).join(
                Patient, on=(FListe.ipp == Patient.ipp).alias('scan_obj')).where((FListe.service == u.service) & (
                    FListe.ipp.contains(_ipp) | Patient.nom.contains(_ipp) | Patient.prenom.contains(_ipp))).order_by(FListe.liste))  # noqa

            logger.info('Listes sorties, Lines : %s.' % len(ucd_cip_list))
            _o = {
                'text': '<b>'+u.fusion+'</b>',
                'id': u.service,
                'children': []
            }
            for c in ucd_cip_list:
                _child = {
                    'text': c.liste,
                    'id': c.liste + " " + c.scan_obj.nom + " " + c.scan_obj.prenom,
                }
                _o['children'].append(_child)
            _out.append(_o)

        return _out


class ApiListesSortiesItems(Resource):

    def delete(self):
        args = parser.parse_args()
        _pk = args['pk']
        _item = args['item']
        logger.info("Suppression des items d'une liste de sorties: %s" % _pk)

        try:

            # get list label (needed to fetch items)
            _l = FListe.select(FListe.liste).where(FListe.liste == _pk)

            if len(_l) == 0:
                logger.error("Liste de sorties non trouvée: %s" % _pk)
                return {'message': "Liste de sorties non trouvée!"}, 503

            FItem.delete().where((FItem.liste == _pk) & (FItem.mode == 'S') & (FItem.item == _item)).execute()

            logger.info("Suppression réussie d'une liste de sorties: %s" % _pk)
            return {'message': 'Success', 'id': None}

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400


class ApiPerimes(Resource):

    def get(self):
        logger.info("Calcul d'une liste de sortie de périmés")

        args = parser.parse_args()
        mag = args['mag']
        date_peremption = args['date_peremption']
        res = []

        try:
            _m = (Stock.select(
                Stock.reference, Stock.fraction, Stock.date_peremption, Stock.quantite, Stock.adresse,
                Product.designation
                ).join(Product, on=(Product.reference == Stock.reference))
                .where((Stock.magasin == mag) & (Stock.date_peremption <= date_peremption)))

            for ls in _m:

                res.append({
                    'ref': ls.reference,
                    'designation': ls.product.designation,
                    'fraction': ls.fraction,
                    'date_peremption': str(ls.date_peremption)[0:10],
                    'quantite': ls.quantite,
                    'adresse': ls.adresse,
                })

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        logger.info("Génération automatique d'une liste de périmés... REUSSI")

        return res

    def post(self):
        res = request.get_json(force=True)
        type_mag = res["type_mag"]
        date_peremption = res["date_peremption"]

        try:
            service = RawConfig('TOUS').read(param='k_ua_perime').value
            logger.info('UF des périmés ' + service)
        except Exception as error:
            logger.error(error.args)
            return {'message': "k_ua_pui n'est pas définit."}, 503

        liste = '%s PERIME AU %s' % (type_mag, date_peremption)

        # Check if liste is already exists
        try:
            d = FListe.get(liste=liste)

        except DoesNotExist:
            d = FListe(
                liste=liste,
                date_creation=datetime.datetime.now(),
                mode='S',
                etat='V',
                fusion='SORTIE DE PERIMES',
                service=service,
                nb_item=1,
                date_modification=datetime.datetime.now(),
                zone_fin=type_mag,
                sous_secteur=type_mag,
                type_servi=TypeServiListe.GlobaleBoite.value,
                id_servi=2,
            )
            d.save()

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        try:
            # Create f_item
            for r in res["lines"]:
                d.nb_item = d.nb_item + 1
                itm = FItem(
                    liste=liste,
                    reference=r["ref"],
                    mode='S',
                    etat='V',
                    item=str(d.nb_item).zfill(6),
                    qte_dem=r["qte"],
                    fraction=r["frac"],
                    tperemp=str(r["date"]),
                    dest=service,
                    type_servi=TypeServiListe.GlobaleBoite.value,
                    id_servi=2,
                )
                itm.save()
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        d.date_modification = datetime.datetime.now()
        d.save()

        return "ok"


class ApiGlobale(Resource):

    def post(self):
        args = parser.parse_args()
        service = args['service']
        ref = args['ref']
        quantite = args['quantite']
        fraction = args['fraction']

        liste = '%s GLOBALE %s' % (date.today().strftime("%Y-%m-%d"), service)

        # Check if liste is already exists
        try:
            d = FListe.get(liste=liste)

        except DoesNotExist:
            d = FListe(
                liste=liste,
                date_creation=datetime.datetime.now(),
                mode='S',
                etat='V',
                fusion='SORTIE GLOBALE BOITE PASS',
                service=service,
                nb_item=1,
                date_modification=datetime.datetime.now(),
                type_servi=TypeServiListe.GlobaleBoite.value,
                id_servi=2,
                num_ipp='GLOBAL',
                num_sej='GLOBAL',
            )
            d.save()

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        try:
            # Create f_item
            paged_item = FItem.select(FItem.item).where(FItem.liste == liste).order_by(FItem.item.desc())

            if (len(paged_item) == 0):
                item = "000001"
            else:
                item = int(paged_item[0].item) + 1

            itm = FItem(
                liste=liste,
                reference=ref,
                mode='S',
                etat='V',
                item=str(item).zfill(6),
                qte_dem=quantite,
                fraction=fraction,
                dest=service,
                type_servi=TypeServiListe.GlobaleBoite.value,
                id_servi=2,
                num_ipp='GLOBAL',
                num_sej='GLOBAL',
            )
            itm.save()
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        d.date_modification = datetime.datetime.now()
        d.save()

        return "ok"


class ApiGlobale_Pilulier(Resource):

    def post(self):
        args = parser.parse_args()
        service = args['service']
        ref = args['ref']
        quantite = args['quantite']
        fraction = args['fraction']
        mode = args['mode']

        paged_prescription = Prescription.select(
            Prescription.pk).where(Prescription.ipp == "GLOBAL").order_by(Prescription.pk)

        if len(paged_prescription) > 0:
            id_presc = paged_prescription[0].pk
        else:
            p = Prescription(
                ipp='GLOBAL',
                sejour='GLOBAL'
            )
            p.save()
            paged_prescription = Prescription.select(
                Prescription.pk).where(Prescription.ipp == "GLOBAL").order_by(Prescription.pk)
            id_presc = paged_prescription[0].pk

        paged_liste = FListe.select(
            FListe.ddeb).where(
                (FListe.type_servi == TypeServiListe.GlobalePilulier.value) & (FListe.service == service)
            ).order_by(FListe.ddeb.desc())

        if len(paged_liste) > 0:
            ddeb = paged_liste[0].ddeb + timedelta(days=1)
            liste_date = ddeb
            ddeb = str(ddeb)
            ddeb = ddeb[0:10]
            liste = '%s GLOBALE PILULIER %s' % (ddeb, service)
        else:
            liste = '%s GLOBALE PILULIER %s' % (date.today().strftime("%Y-%m-%d"), service)
            liste_date = date.today()

        # Check if liste is already exists
        try:
            d = FListe.get(liste=liste)

        except DoesNotExist:
            d = FListe(
                liste=liste,
                date_creation=datetime.datetime.now(),
                mode='S',
                etat='V',
                fusion='SORTIE GLOBALE PILULIER',
                service=service,
                nb_item=1,
                date_modification=datetime.datetime.now(),
                type_servi=TypeServiListe.GlobalePilulier.value,
                id_servi=0,
                num_ipp='GLOBAL',
                num_sej='GLOBAL',
                ddeb=liste_date,
                id_prescription=id_presc
            )
            d.save()

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        try:
            # Create f_item
            itm_restant = quantite
            alveole_theo = 1
            if mode == "1":
                qte_max = 10
            else:
                qte_max = 5

            while int(itm_restant) > 0:
                if int(itm_restant) > qte_max:
                    quantite_new = qte_max
                else:
                    quantite_new = itm_restant

                if alveole_theo > 4:
                    alveole_theo = 1
                    liste_date = liste_date + timedelta(days=1)
                    liste = '%s GLOBALE PILULIER %s' % (liste_date.strftime("%Y-%m-%d"), service)
                    try:
                        d = FListe.get(liste=liste)

                    except DoesNotExist:

                        d = FListe(
                            liste=liste,
                            date_creation=datetime.datetime.now(),
                            mode='S',
                            etat='V',
                            fusion='SORTIE GLOBALE PILULIER',
                            service=service,
                            nb_item=1,
                            date_modification=datetime.datetime.now(),
                            type_servi=TypeServiListe.GlobalePilulier.value,
                            id_servi=0,
                            num_ipp='GLOBAL',
                            num_sej='GLOBAL',
                            ddeb=liste_date,
                            id_prescription=id_presc
                        )
                        d.save()

                paged_item = FItem.select(FItem.item).where(FItem.liste == liste).order_by(FItem.item.desc())

                if (len(paged_item) == 0):
                    item = "000001"
                else:
                    item = int(paged_item[0].item) + 1

                if alveole_theo == 1:
                    moment = 'matin'

                if alveole_theo == 2:
                    moment = 'midi'

                if alveole_theo == 3:
                    moment = 'soir'

                if alveole_theo == 4:
                    moment = 'coucher'

                itm = FItem(
                    liste=liste,
                    reference=ref,
                    mode='S',
                    etat='V',
                    item=str(item).zfill(6),
                    qte_dem=quantite_new,
                    fraction=fraction,
                    dest=service,
                    type_servi=TypeServiListe.GlobalePilulier.value,
                    id_servi=0,
                    num_ipp='GLOBAL',
                    num_sej='GLOBAL',
                    alveole_theo=alveole_theo,
                    dtprise=liste_date,
                    moment=moment
                )
                itm.save()
                item = int(item) + 1
                itm_restant = int(itm_restant) - qte_max
                alveole_theo = alveole_theo + 1
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

        d.date_modification = datetime.datetime.now()
        d.save()

        logger.info("mode: %s" % mode)

        return "ok"
