from flask_restful import Resource, reqparse
# from flask import session
from median.models import FListe, FItem, Magasin
from median import views as v
from common.util import logger
from common.util import Success
from common.status import HTTP_400_BAD_REQUEST, HTTP_503_SERVICE_UNAVAILABLE
# from peewee import fn

parser = reqparse.RequestParser()
parser.add_argument('mag')
parser.add_argument('libelle')
parser.add_argument('pk')


class ApiListesReappro(Resource):

    def get(self):
        logger.info("Récupérer les listes de réappro...")
        lis = FListe.select(FListe.pk, FListe.liste).where(
            FListe.mode == 'E', FListe.zone_deb == ''
        ).order_by(FListe.zone_fin, FListe.pk)
        logger.info('Récupérer les listes de réappro ACCED... %s' % lis.count())
        return ([{'pk': li.pk, 'label': li.liste} for li in lis])

    def post(self):
        logger.info("Génération automatique d'une liste d'entrée...")

        args = parser.parse_args()
        _mag_long = args['mag']
        _libelle = args['libelle']
        res = ""

        try:
            _m = Magasin.select(Magasin.mag).where(Magasin.type_mag == _mag_long)

            if len(_m) == 0:
                logger.error("Magasin non trouvé: " + _mag_long)
                return {'message': "Magasin non trouvé: " + _mag_long}, HTTP_400_BAD_REQUEST

            res = v.Seuil().reappro_liste(_mag_long, _libelle)

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, HTTP_400_BAD_REQUEST

        logger.info("Génération automatique d'une liste d'entrée... REUSSI")
        return Success(message='success', id=res.pk, liste=res.liste)

    def delete(self):
        args = parser.parse_args()
        _pk = args['pk']
        logger.info("Suppression d'une liste de réappro: %s" % _pk)

        try:

            # get list label (needed to fetch items)
            _l = FListe.select(FListe.liste).where(FListe.pk == _pk)

            if len(_l) == 0:
                logger.error("Liste de réappro non trouvée: %s" % _pk)
                return {'message': "Liste de réappro non trouvée!"}, HTTP_503_SERVICE_UNAVAILABLE

            FItem.delete().where((FItem.liste == _l[0].liste) & (FItem.mode == 'E')).execute()
            FListe.delete().where((FListe.pk == _pk) & (FListe.mode == 'E')).execute()

            logger.info("Suppression réussie d'une liste de réappro: %s" % _pk)
            return {'message': 'Success', 'id': None}

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, HTTP_400_BAD_REQUEST


class ApiCalculReappro(Resource):

    def post(self):
        logger.info("Calcul d'une liste d'entrée de reappro")

        args = parser.parse_args()
        _mag_long = args['mag']
        res = ""

        try:
            _m = Magasin.select(Magasin.mag).where(Magasin.type_mag == _mag_long)

            if len(_m) == 0:
                logger.error("Magasin non trouvé: " + _mag_long)
                return {'message': "Magasin non trouvé: " + _mag_long}, HTTP_400_BAD_REQUEST

            res = v.Seuil().reappro_calcul(_mag_long)

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, HTTP_400_BAD_REQUEST

        logger.info("Génération automatique d'une liste d'entrée... REUSSI")

        return res
