from flask_restful import Resource, reqparse
# from flask import session
from median.models import Espace
from median.views import Seuil as V_Seuil
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('product_ref')
parser.add_argument('mag')
parser.add_argument('fraction')
parser.add_argument('quantite')


class ApiListeEntrees(Resource):

    def post(self, ref):

        logger.info("Création d'une liste d'entrée...")

        args = parser.parse_args()
        _fraction = args['fraction']
        _qte = args['quantite']
        _poste = args['mag']

        try:
            _esp = Espace.select(Espace.mag).where(Espace.poste == _poste)
            # V_Seuil().reappro(ref, _esp[0].mag, _qte, _fraction)
            V_Seuil().reappro(ref, _esp[0].mag, _qte, _fraction)

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503

        logger.info('Création d\'une liste d\'entrée... REUSSI')
        return 'Success'

    # def _get_seuil_commande(self, ref, fraction, stock_maxi):
    #     _q = (
    #             Stock
    #             .select(((stock_maxi - fn.SUM(Stock.quantite)) * fraction / 100).alias('comm'))
    #             .where((Stock.reference == ref) & (Stock.fraction == fraction))
    #         )

    #     if _q.count() == 0:
    #         return stock_maxi * fraction / 100

    #     return round(_q[0].comm) or 0
