from flask_restful import Resource
from median.models import Label


class ApiLabels(Resource):

    LABEL_DCI = 'ref_dci'
    LABEL_DESIG_BIS = 'ref_desig_bis'
    DEFAULT_LABEL_DCI = 'DCI'
    DEFAULT_LABEL_DESIG_BIS = 'Desig bis'

    def get(self):
        _dl = (Label.get_or_none(Label.code == self.LABEL_DCI))
        _dbl = (Label.get_or_none(Label.code == self.LABEL_DESIG_BIS))

        if _dl:
            _dci_label = _dl.libelle
        else:
            _dci_label = self.DEFAULT_LABEL_DCI

        if _dbl:
            _desig_bis_label = _dbl.libelle
        else:
            _desig_bis_label = self.DEFAULT_LABEL_DESIG_BIS

        return {'dci': _dci_label, 'desig_bis': _desig_bis_label}
