from flask_restful import reqparse
from common.rest import DataTables
from median.models import User
from common.util import logger
from peewee import DoesNotExist
from median.database import decripte

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')


class DataTableUsers(DataTables):

    def post(self):

        args = parser.parse_args()
        v_draw = args['draw']
        v_limit = args['length']
        v_offset = args['start']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']

        logger.info("Récupérer les utilisateurs")

        try:

            if v_orderby == 1:
                v_orderby_column = User.username
            elif v_orderby == 2:
                v_orderby_column = User.profil
            elif v_orderby == 3:
                v_orderby_column = User.maintenance
            elif v_orderby == 4:
                v_orderby_column = User.droit_stupefiant
            else:
                v_orderby_column = User.username

            if v_dir == 'desc':
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            total_users_count = (
                    User.select(User.pk).count())

            paged_users = (User.select(
                User.pk, User.username, User.profil, User.password, User.maintenance,
                User.droit_stupefiant, User.email)
                .limit(v_limit).offset(v_offset).order_by(v_orderby_column_dir))

            return self.render([{
                'pk': i.pk,
                'user': i.username,
                'profil': i.profil,
                'password': decripte(i.password),
                'maintenance': i.maintenance,
                'stupefiant': i.droit_stupefiant,
                'email': i.email
            } for i in paged_users], v_draw, total_users_count, total_users_count)

        except DoesNotExist:
            logger.error('Get users Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error(('Get users Datatables raised an exception: ', error.args))
            return self.render([], v_draw, 0, 0, error.args)
