from common.rest import DataTables
from flask_restful import reqparse
from median.models import Cadence_Pilulier_Par_Service, Cadence_Carnet_Par_Service
from datetime import datetime, timedelta

parser = reqparse.RequestParser()
parser.add_argument("date")
parser.add_argument("mag")


class DataTableCadencePilulierParService(DataTables):

    def post(self):

        args = parser.parse_args()
        v_date = args['date']
        v_mag = args['mag']

        date_fin = datetime.strptime(v_date, "%Y-%m-%d") + timedelta(days=1)

        paged_emplacements = (Cadence_Pilulier_Par_Service.select(
                ).where((Cadence_Pilulier_Par_Service.chrono >= v_date) & (
                    Cadence_Pilulier_Par_Service.chrono <= date_fin)
                & (Cadence_Pilulier_Par_Service.poste == v_mag)).limit(100))

        return self.render([{
            'chrono': str(i.chrono),
            'service': i.service,
            'heuredebut': i.heure_debut,
            'duree': i.duree,
            'tempsarret': i.temps_arret,
            'nbproduit': i.nbproduit,
            'nbproduitheure': i.nbproduitheure,
            'nbpilulier': i.nbpilulier,
            'nbpilulierheure': i.nbpilulierheure,
            'nbplateau': i.nbplateau,
            'nbplateauheure': i.nbplateauheure,
        } for i in paged_emplacements], 0, 100, 100)


class DataTableCadenceCarnetParService(DataTables):

    def post(self):

        args = parser.parse_args()
        v_date = args['date']
        v_mag = args['mag']

        date_fin = datetime.strptime(v_date, "%Y-%m-%d") + timedelta(days=1)

        paged_emplacements = (Cadence_Carnet_Par_Service.select(
                ).where((Cadence_Carnet_Par_Service.chrono >= v_date) & (
                    Cadence_Carnet_Par_Service.chrono <= date_fin)
                & (Cadence_Carnet_Par_Service.poste == v_mag)).limit(100))

        return self.render([{
            'chrono': str(i.chrono),
            'service': i.service,
            'heuredebut': i.heure_debut,
            'duree': i.duree,
            'tempsarret': i.temps_arret,
            'nbproduit': i.nbproduit,
            'nbproduitheure': i.nbproduitheure,
            'nbcarnet': i.nbcarnet,
            'nbcarnetheure': i.nbcarnetheure,
            'nbpilulier': i.nbpilulier,
            'nbpilulierheure': i.nbpilulierheure,
            'nbplateau': i.nbplateau,
            'nbplateauheure': i.nbplateauheure,
        } for i in paged_emplacements], 0, 100, 100)
