from flask_restful import reqparse
from common.rest import DataTables
from common.util import logger
from median.models import Stock
from peewee import DoesNotExist


parser = reqparse.RequestParser()
parser.add_argument('product_ref')
parser.add_argument('select')
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Start parameter for Datatables')
parser.add_argument('length', type=int, help='Limit parameter for Datatables')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument("filterByMagasin")
parser.add_argument("form_data")
parser.add_argument("pk")
parser.add_argument("adresse")
parser.add_argument("is_empty_container")
parser.add_argument("service")
parser.add_argument("qte_mvt")
parser.add_argument("lot")
parser.add_argument("date_peremption")
parser.add_argument("contenant")
parser.add_argument("ucd")
parser.add_argument("fraction")

parser.add_argument("quantite_new")
parser.add_argument("quantite_old")
parser.add_argument("lot_new")
parser.add_argument("lot_old")
parser.add_argument("date_peremption_new")
parser.add_argument("date_peremption_old")
parser.add_argument("service")


class DatatableStock(DataTables):

    def post(self, ref):
        args = parser.parse_args()
        v_draw = args['draw']
        # v_start = args['start']
        # v_length = args['length']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']
        v_filter_by_magasin = args['filterByMagasin']

        try:
            if not v_filter_by_magasin:
                total_stocks_count = (
                    Stock.select(
                        Stock.pk,
                        Stock.bloque,
                        Stock.quantite)
                    .where(Stock.reference == ref)
                    .count())
                filtered_stocks_query = (
                    Stock.select().where(Stock.reference == ref))
            else:
                ms = v_filter_by_magasin.split(",")
                total_stocks_count = (
                    Stock.select(Stock.pk, Stock.bloque, Stock.quantite)
                    .where((Stock.reference == ref) & (Stock.magasin << ms))
                    .count())
                filtered_stocks_query = (
                    Stock.select().where((Stock.reference == ref) & (Stock.magasin << ms)))

            if (v_orderby == 1):
                v_orderby_column = Stock.bloque
            elif (v_orderby == 2):
                v_orderby_column = Stock.adresse
            elif (v_orderby == 3):
                v_orderby_column = Stock.quantite
            elif (v_orderby == 4):
                v_orderby_column = Stock.fraction
            elif (v_orderby == 5):
                v_orderby_column = Stock.ucd
            elif (v_orderby == 6):
                v_orderby_column = Stock.date_sortie
            elif (v_orderby == 7):
                v_orderby_column = Stock.date_entree
            elif (v_orderby == 8):
                v_orderby_column = Stock.lot
            elif (v_orderby == 9):
                v_orderby_column = Stock.date_peremption
            elif (v_orderby == 10):
                v_orderby_column = Stock.contenant
            else:
                v_orderby_column = Stock.adresse

            if (v_dir == 'desc'):
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            filtered_stocks = (filtered_stocks_query
                               .order_by(v_orderby_column_dir))

            # paged_stocks = filtered_stocks.limit(v_length).offset(v_start)

            logger.debug('Lines : %s.' % len(filtered_stocks))

            return self.render([{
                'pk': s.pk,
                'bloque': ('OUI' if s.bloque else 'NON'),
                'emplacement': s.adresse,
                'quantite': s.quantite,
                'ucd': s.ucd,
                'date_sortie': str(s.date_sortie or '-'),
                'date_entree': str(s.date_entree or '-'),
                'lot': s.lot,
                'date_peremption': str(s.date_peremption).split(' ')[0],
                'contenant': s.contenant,
                'fraction': s.fraction,
                'qte_blister_bac': s.qte_blister_bac,
                'nb_dose_cut': s.nb_dose_cut,
                'du': s.DU,
                'qte_prod_blister': s.qte_prod_blister,
            } for s in filtered_stocks],
                v_draw,
                total_stocks_count,
                len(filtered_stocks))

        except DoesNotExist:
            logger.error('Get stock Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error('Get stock Datatables raised an exception: ', error.args)
            return self.render([], v_draw, 0, 0, error.args)
