from flask_restful import reqparse
from common.rest import DataTables
from median.models import Service, Config
from common.util import logger
from peewee import DoesNotExist
from common.status import HTTP_400_BAD_REQUEST

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')


class DataTableServices(DataTables):

    def get(self):

        return {'message': 'Use POST request'}, HTTP_400_BAD_REQUEST

    def post(self):

        args = parser.parse_args()
        v_draw = args['draw']
        v_limit = args['length']
        v_offset = args['start']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']

        logger.info("Récupérer les services")

        try:

            if v_orderby == 1:
                v_orderby_column = Service.code
            elif v_orderby == 2:
                v_orderby_column = Service.libelle
            elif v_orderby == 3:
                v_orderby_column = Service.type_peigne
            elif v_orderby == 4:
                v_orderby_column = Service.moment_deb
            elif v_orderby == 5:
                v_orderby_column = Service.deb_matin
            elif v_orderby == 6:
                v_orderby_column = Service.deb_midi
            elif v_orderby == 7:
                v_orderby_column = Service.deb_soir
            elif v_orderby == 8:
                v_orderby_column = Service.deb_coucher
            elif v_orderby == 9:
                v_orderby_column = Service.tri
            else:
                v_orderby_column = Service.code

            if v_dir == 'desc':
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            paged_services = (Service.select(Service).where(
                Service.type_dest == 'SERVICE').limit(v_limit).offset(v_offset).order_by(
                v_orderby_column_dir, Service.code)
            )

            nb_record = Service.select().where(Service.type_dest == 'SERVICE').count()

            param_tri = Config.select(Config.value).where(Config.propriete == 'k_eco_tri_pil')

            k_tri = param_tri[0].value

            return self.render([{
                'dest': i.code,
                'libelle': i.libelle,
                'type_peigne': i.type_peigne,
                'moment_deb': i.moment_deb,
                'deb_matin': i.deb_matin,
                'deb_midi': i.deb_midi,
                'deb_soir': i.deb_soir,
                'deb_coucher': i.deb_coucher,
                'tri': (i.tri if (i.tri != '') else k_tri)
            } for i in paged_services], v_draw, nb_record, nb_record)

        except DoesNotExist:
            logger.error('Get services Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error(('Get services Datatables raised an exception: ', error.args))
            return self.render([], v_draw, 0, 0, error.args)
