from flask_restful import reqparse
from common.rest import DataTables
# from flask import session
# from median.models import FListe
from peewee import DoesNotExist
from common.util import logger
from median.views import Dispensation

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument('ipp')


class DataTableListeSortiesListes(DataTables):

    def post(self, service):

        args = parser.parse_args()
        v_draw = args['draw']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']
        _ipp = args['ipp']

        logger.info("Récupérer les listes de sorties, pk du service : '%s'" % service)
        logger.info("Récupérer les listes de sorties, ipp : '%s'" % _ipp)

        try:

            if (v_orderby == 1):
                v_orderby_column = "x_liste"
            elif (v_orderby == 2):
                v_orderby_column = "x_nom"
            else:
                v_orderby_column = "x_liste"

            if (v_dir != 'desc'):
                v_dir = 'asc'

            if _ipp is None:
                _ipp = ''

            _disp = Dispensation()
            _liste = _disp.affichage(service, _ipp, v_orderby_column, v_dir)

            if len(_liste) == 0:
                # logger.error('No list for id %s' % _ipp)
                return self.render([], v_draw, 0, 0)

            return self.render([{
                'pk': i['x_pk'],
                'code_livraison': i['x_code_liv'],
                'liste': i['x_liste'],
                'nom': i['x_nom'],
            } for i in _liste], v_draw, 0, 0)

        except DoesNotExist:
            logger.error('Get reappro items Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error(('Get reappro items Datatables raised an exception: ', error.args))
            return self.render([], v_draw, 0, 0, error.args)
