from flask_restful import reqparse
from common.rest import DataTables
# from flask import session
from median.models import FListe, FItem, Product
from peewee import DoesNotExist
from common.util import logger

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument("filterByMagasin")


class DataTableListeReapproItems(DataTables):

    def post(self, pk_liste):
        # nb_item = 0

        args = parser.parse_args()
        v_draw = args['draw']
        v_limit = args['length']
        v_offset = args['start']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']
        v_filter_by_magasin = args['filterByMagasin']

        logger.info("Récupérer les items de listes de réappro, pk de la liste : '%s'" % pk_liste)

        try:
            pk_liste = int(pk_liste)
            # on récupère le libellé de la liste
            # c'est nul, mais c'est comme ça qu'on retrouve les items pour l'instant
            _liste = FListe.select(FListe.liste, FListe.nb_item).where((FListe.pk == pk_liste) & (FListe.mode == 'E'))

            if len(_liste) == 0:
                logger.error('No list for id %s' % pk_liste)
                return self.render([], v_draw, 0, 0)

            # nb_item = _liste[0].nb_item

            if (v_orderby == 0):
                v_orderby_column = FItem.etat
            elif (v_orderby == 1):
                v_orderby_column = FItem.reference
            elif (v_orderby == 2):
                v_orderby_column = FItem.fraction
            elif (v_orderby == 3):
                v_orderby_column = Product.designation
            elif (v_orderby == 4):
                v_orderby_column = FItem.qte_dem
            elif (v_orderby == 5):
                v_orderby_column = FItem.qte_serv
            else:
                v_orderby_column = FItem.item

            if (v_dir == 'desc'):
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            ms = v_filter_by_magasin.split(",")

            # on récupère les items de cette liste
            _items_count = (
                FItem.select(
                    FItem.pk
                )
                .where((FItem.liste == _liste[0].liste) & (FItem.etat << ms))
                .count())

            _items = FItem.select(
                    FItem.pk,
                    FItem.etat,
                    FItem.reference,
                    FItem.fraction,
                    Product.designation,
                    FItem.qte_dem,
                    FItem.qte_serv
                    ).join(Product, on=(Product.reference == FItem.reference)).where(
                        (FItem.liste == _liste[0].liste) & (FItem.etat << ms)).limit(
                        v_limit).offset(v_offset).order_by(v_orderby_column_dir)

            return self.render([{
                'pk': i.pk,
                'etat': self._get_etat_human_label(i.etat),
                'reference': i.reference,
                'fraction': i.fraction,
                'designation': i.product.designation,
                'qte_demandee': i.qte_dem,
                'qte_servie': i.qte_serv
            } for i in _items], v_draw, _items_count, _items_count)

        except DoesNotExist:
            logger.error('Get reappro items Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error('Get reappro items Datatables raised an exception: ', error.args)
            return self.render([], v_draw, 0, 0, error.args)

    def _get_etat_human_label(self, etat_short_label):
        options = {
            'V': 'Vierge',
            'E': 'Entamé',
            'S': 'Soldé'
        }
        return options.get(etat_short_label, 'Inconnu')
