from flask_restful import Resource
from median.models import Adresse
import logging

logger = logging.getLogger('median.webserver')


class ApiContainerFormat(Resource):

    def get(self, mag=None):
        try:
            if not mag:
                cf = (Adresse.select(Adresse.format).distinct()
                      .order_by(Adresse.format))
            else:
                cf = (Adresse.select(Adresse.format).distinct()
                      .where(Adresse.magasin == mag).order_by(Adresse.format))
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503

        logger.info('Lines : %s.' % len(cf))
        return ([{
            'format': c.format
        } for c in cf])
