from flask_restful import Resource, reqparse
from flask import session
from peewee import fn
from median.models import Adresse, Stock, Historique
import urllib.parse
import datetime
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('form_data')
parser.add_argument('origin_adresse')
parser.add_argument('lot')
parser.add_argument('date_peremption')
parser.add_argument('ucd')
parser.add_argument('fraction')
parser.add_argument('pk')
parser.add_argument('ref')
parser.add_argument('adr')


class ApiContainerAddress(Resource):

    def put(self, ref):

        # récupérer les arguments
        args = parser.parse_args()
        form_data = urllib.parse.parse_qs(args['form_data'])
        origin_adresse = self._padAddressField(args['origin_adresse'])
        dest_addresse = self._padAddressField(form_data['adresse'][0])
        # service = form_data['service'][0]
        mag = form_data['magasin'][0]

        lot = args['lot']
        peremp = args['date_peremption']
        ucd = args['ucd']
        fraction = args['fraction']
        # _pk = args['pk']

        logger.info('Déplacement de contenant, de "%s" vers "%s"' % (origin_adresse, dest_addresse))

        qte_tot = (Stock.select(fn.SUM(Stock.quantite)).where(Stock.reference == ref))
        logger.debug('Calcul quantité totale: "%s"' % (qte_tot))

        # on récupère le x_contenant de l'ancienne adresse
        x_cont = Adresse.get(Adresse.adresse == origin_adresse).contenant
        logger.debug('Récupération du code contenant de l\'ancienne adresse: "%s"' % (x_cont))

        # mise à jour dans la table f_stock
        logger.debug('Mise à jour adresse dans la table f_stock...')
        qqq = Stock.update({Stock.adresse: dest_addresse, Stock.magasin: mag}).where((Stock.adresse == origin_adresse))
        qqq.execute()

        # mise à jour dans la table f_adr
        logger.debug('Mise à jour adresse dans la table f_adr...')
        logger.debug('On libère l\'adresse d\'origine...')
        # on libère l'adresse d'origine
        if form_data['move_container_is_empty'][0] == 'yes':
            q = Adresse.update({Adresse.etat: 'L'}).where(Adresse.adresse == origin_adresse)
        else:
            q = Adresse.update({Adresse.etat: 'L', Adresse.contenant: None}).where(Adresse.adresse == origin_adresse)
        q.execute()

        # l'adresse de destination devient occupée
        logger.debug('L\'adresse de destination devient occupée...')
        qq = Adresse.update({Adresse.etat: 'O', Adresse.contenant: x_cont}).where(Adresse.adresse == dest_addresse)
        qq.execute()

        # si besoin, on avance les contenants qui se trouvaient derrière
        logger.debug('Si besoin, on avance les contenants qui se trouvaient derrière...')
        if form_data['move_container_is_empty'][0] != 'yes':
            self._moveContainerForward(origin_adresse)

        logger.debug('Sauvegarde dans la table historique')
        Historique.create(
            chrono=datetime.datetime.now(),
            reference=ref,
            adresse=dest_addresse,
            adresse_from=origin_adresse,
            quantite_mouvement=0,
            quantite_totale=qte_tot,
            # service=service,
            type_mouvement='TRF',
            lot=lot,
            pmp=0,
            date_peremption=peremp,
            contenant=x_cont,
            poste='MEDIAN_CL',
            ucd=ucd,
            fraction=fraction,
            commentaire="Déplacement manuel d'une boîte",
            utilisateur=session['username']
        )

        logger.info('Fin du déplacement de contenant')

        return "ok"

    def get(self):
        args = parser.parse_args()
        # _ref = args['ref']
        _adr = args['adr']
        _adrs = Stock.select().where(Stock.adresse == self._padAddressField(_adr))
        logger.info('Lines : %s.' % _adrs.count())
        return _adrs.count()

    def _padAddressField(self, adr):

        _adr_items = adr.split('.')
        _o = []
        for a in _adr_items:
            _o.append(a.rjust(3))
        return '.'.join(_o)

    def _moveContainerForward(self, adr):
        _els = adr.split('.')
        _pos = int(_els[-1].lstrip())
        if _pos > 1:
            return False

        _back_adrs = []
        _els[-1] = '  2'
        _back_adrs.append('.'.join(_els))
        _els[-1] = '  3'
        _back_adrs.append('.'.join(_els))

        _a = (Adresse.select(Adresse.contenant)
                     .where((Adresse.adresse == _back_adrs[0]) | (Adresse.adresse == _back_adrs[1])))
        _cont = _a[0].contenant

        (Adresse.update({Adresse.contenant: _cont, Adresse.etat: 'O'})
            .where(Adresse.adresse == adr).execute())

        (Adresse.update({Adresse.contenant: '', Adresse.etat: 'L'})
            .where((Adresse.adresse == _back_adrs[0]) | (Adresse.adresse == _back_adrs[1]))
            .execute())

        (Stock.update({Stock.adresse: adr})
            .where((Stock.adresse == _back_adrs[0]) | (Stock.adresse == _back_adrs[1]))
            .execute())
