from flask_restful import Resource, reqparse
from median.models import Adresse
from median.views import Emplacement
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('reference')
parser.add_argument('origin_adresse')
parser.add_argument('fraction')
parser.add_argument('magasin')
parser.add_argument('format')
parser.add_argument('creation')


class ApiAvailableAdresses(Resource):

    def get(self):
        # get args
        args = parser.parse_args()
        _ref = args['reference']
        _adr = args['origin_adresse']
        # _fraction = args['fraction']
        _mag = args['magasin']
        _format = args['format']
        # _c = args['creation']

        _creation = True if args['creation'] == 'true' else False

        try:
            # get format for origin_address
            if _adr != '-':
                _format = Adresse.get(Adresse.adresse == self._padAddressField(_adr)).format
            else:
                _format = _format.replace('__', ' ')

            # get available addresses
            _available_adr = Emplacement.libre(_ref, _mag, _format, _creation)
            logger.info('Lines : %s.' % len(_available_adr))

        except Exception as error:
            logger.error('Exception levée en cherchant les emplacements libres. Variables => '
                         'ref: "%s", magasin: "%s", format: "%s", creation: "%s"' % (_ref, _mag, _format, _creation))
            return {'message': error.args}, 503

        return _available_adr

    def _padAddressField(self, adr):
        _adr_items = adr.split('.')

        _o = []
        for a in _adr_items:
            _o.append(a.rjust(3))

        return '.'.join(_o)
