from ressources.user import ApiUser
from ressources.users import ApiUsers, ApiProfil, ApiMenu
from ressources.product import ApiProduct
from ressources.product_param import ApiProductParam
from ressources.products import ApiProducts
from ressources.suggestions import ApiSuggestions
from ressources.labels import ApiLabels
from ressources.reporting import ApiReporting
from ressources.magasin import ApiMagasin
from ressources.container_format import ApiContainerFormat
from ressources.adresse import ApiAdresse
from ressources.available_addresses import ApiAvailableAdresses
from ressources.stock import ApiStock
from ressources.seuils import ApiSeuils
from ressources.liste_entrees import ApiListeEntrees
from ressources.liste_sorties import ApiListeSorties
from ressources.liste_sorties_items import ApiListesSortiesItems
from ressources.ucd_cip import ApiUcdCip
from ressources.lots_retires import ApiLotsRetires
from ressources.services import ApiServices
from ressources.services_with_dispensations import ApiServicesWithDispensations
from ressources.container_address import ApiContainerAddress
from ressources.sortie_unitaire import ApiSortieUnitaire
from ressources.sortie_globale import ApiSortieGlobale
from ressources.listes_reappro import ApiListesReappro, ApiCalculReappro
from ressources.listes_sorties import ApiListesSorties, ApiPerimes, ApiGlobale, ApiGlobale_Pilulier
from ressources.suggestions_liste_entrees import ApiSuggestions_Liste_Entrees
from ressources.suggestions_patient import ApiSuggestions_Patient
from ressources.suggestions_ucd_lot_histo import ApiSuggestions_UCD_Lot_Histo
from ressources.lot import ApiLot
from ressources.lots import ApiLots
from ressources.stocks import ApiStocks
from ressources.reappro import ApiReappro, ApiReapproItem
from ressources.dashboard import ApiDashboard_Cueillette_v3, ApiExportCompteurs
from ressources.dashboard import ApiDashboard_Coupe, ApiDashboard_Cueillette, ApiDashboard_Retour
from ressources.suivi_production import ApiSuiviProduction
from ressources.riedl import ApiRiedlEquipment, ApiRiedlEndpoint
from ressources.riedl_liste_entrees import ApiRiedlListesEntrees
from ressources.riedl_liste_sorties import ApiRiedlListesSorties, ApiRiedlCommandSorties


def add_res_route(api_handle):
    """Add dynamic route to general object"""
    api_handle.add_resource(ApiUser, '/user', '/user/<string:ressource>')
    api_handle.add_resource(ApiUsers, '/users')
    api_handle.add_resource(ApiProfil, '/profils')
    api_handle.add_resource(ApiMenu, '/menu')
    api_handle.add_resource(ApiReporting, '/reporting', '/reporting/<string:ressource>')
    api_handle.add_resource(ApiProducts, '/products')
    api_handle.add_resource(ApiProduct, '/product/', '/product/<string:ref>')
    api_handle.add_resource(ApiProductParam, '/product_param', '/product_param/<string:ref>')
    api_handle.add_resource(ApiSortieUnitaire, '/sortie_unitaire/<string:ref>')
    api_handle.add_resource(ApiSortieGlobale, '/sortie_globale/<string:ref>')
    api_handle.add_resource(ApiLot, '/lot/<string:ucd>')
    api_handle.add_resource(ApiLots, '/lots/<string:ucd>')
    api_handle.add_resource(ApiStock, '/stock/<string:ref>')
    api_handle.add_resource(ApiSeuils, '/seuils/<string:ref>')
    api_handle.add_resource(ApiListeEntrees, '/liste_entrees/<string:ref>')
    api_handle.add_resource(ApiListeSorties, '/liste_sorties/<string:ref>')
    api_handle.add_resource(ApiUcdCip, '/ucd_cip/<string:ref>')
    api_handle.add_resource(ApiLotsRetires, '/lots_retires/<string:ref>')
    api_handle.add_resource(ApiSuggestions, '/suggestions')
    api_handle.add_resource(ApiLabels, '/labels')
    api_handle.add_resource(ApiMagasin, '/magasins')
    api_handle.add_resource(ApiListesReappro, '/listes_reappro')
    api_handle.add_resource(ApiCalculReappro, '/calcul_reappro')
    api_handle.add_resource(ApiAdresse, '/adresse/<string:adr>',
                            '/adresses/<string:mag>/<string:format>')
    api_handle.add_resource(ApiAvailableAdresses, '/available_adresses')
    api_handle.add_resource(ApiContainerFormat, '/container_formats/<string:mag>', '/container_formats')
    api_handle.add_resource(ApiServices, '/services')
    api_handle.add_resource(ApiServicesWithDispensations, '/services_with_dispensations')
    api_handle.add_resource(ApiContainerAddress, '/move_container/<string:ref>',
                            '/get_adr')
    api_handle.add_resource(ApiListesSorties, '/listes_sorties')
    api_handle.add_resource(ApiListesSortiesItems, '/listes_sorties_items')
    api_handle.add_resource(ApiSuggestions_Liste_Entrees, '/suggestions_liste_entrees')
    api_handle.add_resource(ApiSuggestions_Patient, '/suggestions_patient')
    api_handle.add_resource(ApiSuggestions_UCD_Lot_Histo, '/suggestions_ucd_lot_histo')
    # api.add_resource(ApiAccount, '/account/<string:username>/<string:password>')
    api_handle.add_resource(ApiStocks, '/stocks/', '/stocks/<string:ref>')
    api_handle.add_resource(ApiReappro, '/reappro')
    api_handle.add_resource(ApiReapproItem, '/reappro_item')
    api_handle.add_resource(ApiDashboard_Coupe, '/dashboard_coupe')
    api_handle.add_resource(ApiDashboard_Cueillette, '/dashboard_cueillette')
    api_handle.add_resource(ApiDashboard_Retour, '/dashboard_retour')
    api_handle.add_resource(ApiDashboard_Cueillette_v3, '/dashboard_cueillette_v3')
    api_handle.add_resource(ApiSuiviProduction, '/suivi_production')
    api_handle.add_resource(ApiPerimes, '/perimes')
    api_handle.add_resource(ApiGlobale, '/globale')
    api_handle.add_resource(ApiGlobale_Pilulier, '/globale_pilulier')
    api_handle.add_resource(ApiExportCompteurs, '/export_compteurs')

    # equipements
    api_handle.add_resource(ApiRiedlEquipment, '/equipement/riedl', '/equipement/riedl/<string:poste>')
    api_handle.add_resource(ApiRiedlListesEntrees, '/riedl/listes_entrees')
    api_handle.add_resource(ApiRiedlListesSorties, '/riedl/listes_sorties', '/riedl/listes_sorties/<string:liste>')
    api_handle.add_resource(ApiRiedlCommandSorties, '/riedl/command_sorties')
    api_handle.add_resource(ApiRiedlEndpoint, '/riedl/endpoint', '/riedl/endpoint/<string:poste>')
