import logging
import socket

logger = logging.getLogger('median.webserver')


def Success(message="", id=None, **kwargs):
    """Format a JSON response"""
    res = {
        'id': id,
        'message': message,
    }
    for arg in kwargs:
        res[arg] = kwargs[arg]

    return res


def compute_checksum(number):
    """Calculate the EAN check digit for 13-digit numbers. The number passed
    should not have the check bit included."""
    if len(number) != 12:
        raise Exception("Invalid length")

    checksum_digit = str(
        (10 - sum((3, 1)[i % 2] * int(n) for i, n in enumerate(reversed(number)))) % 10
    )

    return str(number) + checksum_digit


def send_to_printer(ip_address, port, datas):
    """Send datas to the network printer"""
    mysocket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        mysocket.connect((ip_address, port))
        mysocket.send(datas)
        mysocket.close()
    except Exception:
        logger.error("Error with the connection to the printer %s" % ip_address)
        return False
    return True
