from flask_restful import Resource, reqparse
from common.status import HTTP_501_NOT_IMPLEMENTED

dtparser = reqparse.RequestParser()
dtparser.add_argument('draw', type=int, help='Draw parameter for Datatables')


class DataTables(Resource):
    """Class use with Datable JQuery Plugin"""
    def parameters(self):
        """Read parameter from the request
           See: https://datatables.net/manual/server-side for details
        """
        pass

    def render(self, datas, draw, recordsTotal, recordsFiltered, error=None):
        o = {
            'draw': draw,
            'recordsTotal': recordsTotal,
            'recordsFiltered': recordsFiltered,
            'data': datas
        }
        if error is not None:
            o['error'] = error
        return o


class WebResource(Resource):
    """Parse"""

    def get(self):
        """GET method"""
        return {'message': 'GET method not implemented'}, HTTP_501_NOT_IMPLEMENTED

    def post(sef):
        """POST method"""
        return {'message': 'POST method not implemented'}, HTTP_501_NOT_IMPLEMENTED
