from peewee import (
    AutoField,
    CharField,
    IntegerField,
)
from peewee import SQL
from ..base import WebModel


class WebForm(WebModel):

    pk = AutoField(
        column_name='id', primary_key=True)
    key = CharField(
        column_name='form_key', max_length=32)
    lang_id = IntegerField(
        column_name='lang_id')
    tr_name = CharField(
        column_name='tr_name', max_length=100)

    class Meta:
        table_name = 'web_form_i18n'
        indexes = (
            (('form_key', 'lang_id'), True),
        )
        constraints = [
            SQL('FOREIGN KEY(lang_id) REFERENCES web_lang(id) ON DELETE CASCADE ON UPDATE CASCADE'),
        ]
