from flask_restful import Resource
from flask import session
from median.database import mysql_db
import logging

logger = logging.getLogger('median.webserver')


class ApiUiMenu(Resource):

    def get(self,):

        usr = session['username']
        lang = session.get('user_lang', 'fr_FR')
        lang_id = session.get('user_lang_id', '1')
        res = {
            'logo': 'static/img/brand/logo-deenova.png',
            'menus': [],
            'length': 0,
            'lang': lang,
            'user': usr,
            'equipment': {}
        }
        if not session.get('username', False):
            return res

        res['menus'] = []
        for mnu in self.list_menus(usr, lang_id):
            tmp = mnu
            tmp['child'] = self.list_submenus(usr, mnu['id'], lang_id)
            res['menus'].append(tmp)

        res['length'] = len(res['menus'])

        return res

    def list_menus(self, user, lang='1'):
        """Liste all menus"""
        query = """
                  SELECT wm.id, wm.code, ifnull(wmin.tr_name, wm.name) AS name, ifnull(wm.icon, '') AS icon,
                         ifnull(wm.url, '/') as url, ifnull(wm.anchor, '') as anchor
                  FROM web_menu wm
                  JOIN f_profil fp ON fp.x_resrc = wm.code
                  JOIN f_user fu ON fu.x_profil = fp.x_profil
                  LEFT JOIN web_menu_i18n wmin ON (wmin.menu_id = wm.id AND wmin.lang_id = {1})
                 WHERE fu.x_user = '{0}'
                   AND wm.parent_id IS NULL and (fp.x_visu=1 or fp.x_edit=1)
                 ORDER BY wm.seq_order""".format(user, lang)
        cr = mysql_db.execute_sql(query)

        column_names = [x[0] for x in cr.description]
        return [dict(zip(column_names, row)) for row in cr.fetchall()]

    def list_submenus(self, user, menu_id, lang='1'):
        """Liste all sub-menus"""
        query = """
                  SELECT wm.id, wm.code, ifnull(wmin.tr_name, wm.name) AS name, ifnull(wm.icon, '') AS icon,
                         ifnull(wm.url, '/') as url, ifnull(wm.anchor, '') as anchor
                  FROM web_menu wm
                  JOIN f_profil fp ON fp.x_resrc = wm.code
                  JOIN f_user fu ON fu.x_profil = fp.x_profil
                  LEFT JOIN web_menu_i18n wmin ON (wmin.menu_id = wm.id AND wmin.lang_id = {2})
                 WHERE fu.x_user = '{0}'
                   AND wm.parent_id = {1} and (fp.x_visu=1 or fp.x_edit=1)
                 ORDER BY wm.seq_order""".format(user, menu_id, lang)
        cr = mysql_db.execute_sql(query)

        column_names = [x[0] for x in cr.description]
        return [dict(zip(column_names, row)) for row in cr.fetchall()]
