from flask_restful import Resource, reqparse
# from flask import session
# from median.database import mysql_db
from common.translate import form_18n_to_json
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument("lang")


class ApiUiForm(Resource):

    def post(self,):
        """Retrieve list of all transaltions"""
        args = parser.parse_args()
        code_lang = args.get('lang', 'en')
        res = {
            'lang': code_lang,
            'terms': form_18n_to_json(code_lang)
        }

        return res
