from flask_restful import Resource, reqparse
from median.models import SuiviProd
from peewee import fn
# from median.database import mysql_db
from datetime import datetime, timedelta

parser = reqparse.RequestParser()
parser.add_argument('mag')
parser.add_argument('date')


class ApiSuiviProduction(Resource):

    def get(self):

        args = parser.parse_args()
        v_mag = args['mag']
        v_date = args['date']

        CPT_Goulotte = 0
        CPT_Coupe = 0
        CPT_BoitePassCP = 0
        CPT_Barillet = 0
        CPT_BoitePassBarillet = 0
        CPT_Chargement = 0
        CPT_BoiteStock = 0
        CPT_BoitePassPrépaDirecte = 0
        CPT_BoiteRejetDpdE1 = 0
        CPT_BoiteRejetDlectE1 = 0
        CPT_BoiteRejetErrAxeE1 = 0
        CPT_BoiteRejetDpsE1 = 0
        CPT_BoiteRejetTestE1 = 0
        CPT_BoiteRejetErrTestE1 = 0
        CPT_BoiteRejetDpdE2 = 0
        CPT_BoiteRejetDlectE2 = 0
        CPT_BoiteRejetErrAxeE2 = 0
        CPT_BoiteRejetDpsE2 = 0
        CPT_BoiteRejetTestE2 = 0
        CPT_BoiteRejetErrTestE2 = 0

        API_Nbr_de_Pilulier_Med = 0
        API_Nbr_de_Plateau_Med = 0

        API_Nbr_Carnet_Pilulier_Med = 0
        API_Nbr_de_Plateau_Carnet_Med = 0

        API_Nbr_de_Pilulier_Carnet_Med = 0

        API_Nbr_Blister_Charge_Med = 0
        API_Nbr_Goulotte_Chargee_Med = 0
        API_Nbr_Erreur_Goulotte_Med = 0
        API_Nbr_Blister_pris_Med = 0
        API_Nbr_Rejet_Blister_RB2_Med = 0
        API_Nbr_Rejet_Sachet_RB2_Med = 0
        API_Nbr_Rejet_SachetP_RB2_Med = 0
        API_Nbr_Rejet_Blister_RB1_Med = 0
        API_Nbr_Rejet_Sachet_RB1_Med = 0
        API_Nbr_Rejet_SachetP_RB1_Med = 0
        API_Nbr_Rejet_DU_Med = 0
        API_Nbr_Rejet_Ticket_Med = 0
        API_Nbr_Sachet_Pose_Med = 0
        API_Nbr_SachetP_Pose_Med = 0
        API_Nbr_DU_Pose_Med = 0
        API_Nbr_Ticket_Pose_Med = 0
        API_Nbr_Sachet_Pose_Carnet_Med = 0
        API_Nbr_SachetP_Pose_Carnet_Med = 0
        API_Nbr_Du_Pose_Carnet_Med = 0
        API_Nbr_Ticket_Pose_Carnet_Med = 0
        API_Nbr_Carnet_Pose_Med = 0
        API_Nbr_Coupe_Med = 0
        API_Nbr_BoitePass_RECU_Med = 0
        API_Nbr_BoitePass_CP_Med = 0
        API_Nbr_BoitePass_Barillet_Med = 0
        API_Nbr_Barillet_Med = 0
        API_Nbr_BoiteStock_Med = 0
        API_Nbr_BoitePass_PrepaDir_Med = 0
        API_Nbr_Rejet_Dpd_E1_Med = 0
        API_Nbr_Rejet_Dlect_E1_Med = 0
        API_Nbr_Rejet_Dps_E1_Med = 0
        API_Nbr_Rejet_Test_E1_Med = 0
        API_Nbr_Rejet_ErrTest_E1_Med = 0
        API_Nbr_Rejet_Dpd_E2_Med = 0
        API_Nbr_Rejet_Dlect_E2_Med = 0
        API_Nbr_Rejet_Dps_E2_Med = 0
        API_Nbr_Rejet_Test_E2_Med = 0
        API_Nbr_Rejet_ErrTest_E2_Med = 0
        API_Temps_Chgt_Blister_Med = 0
        API_Temps_Dchgt_Plateau_Med = 0
        API_Temps_Cueil_Pil_Med = 0
        API_Temps_Cueil_Carnet_Med = 0
        API_Nbr_Coupe_Heure_Med = 0
        API_Nbr_RetourProduit_Med = 0
        API_Nbr_Dose_Rangee_Med = 0
        API_Nbr_Dose_Rangee_Heure_Med = 0
        API_Temps_Panne_Med = 0
        API_TEMPS_ATTENTE_OPERATEUR_Med = 0
        API_TEMPS_ATTENTE_ECRAN_Med = 0
        API_TEMPS_RESOLUTION_DEFAUT_Med = 0
        API_TEMPS_UTILISATION_Med = 0
        API_TEMPS_CYCLE_REEL_Med = 0
        API_DISPONIBILITE_Med = 0

        API_Nbr_de_Pilulier_heure_Med = 0
        API_Nbr_de_Pilulier_Carnet_heure_Med = 0

        Nb_doses_Pilulier = 0
        Nb_doses_Carnet = 0

        date_fin = datetime.strptime(v_date, "%Y-%m-%d") + timedelta(days=1)

        # subquery = (SuiviProd
        #     .select(
        #         SuiviProd.variable.alias('variable'),
        #         fn.MAX(SuiviProd.pk).alias('max_pk'))
        #         .where((SuiviProd.poste == v_mag) & (
        #             fn.Substr(SuiviProd.chrono, 1, 10) == v_date))
        #         .group_by(SuiviProd.variable))

        subquery = (SuiviProd.select(SuiviProd.variable.alias('variable'),
                    fn.MAX(SuiviProd.pk).alias('max_pk'))
                    .where((SuiviProd.poste == v_mag) & (
                        SuiviProd.chrono >= v_date) & (
                        SuiviProd.chrono < date_fin))
                    .group_by(SuiviProd.variable))

        compteur = (SuiviProd
                    .select(SuiviProd.pk, SuiviProd.variable, SuiviProd.valeur_num,
                            SuiviProd.valeur_alpha)
                    .join(subquery, on=((subquery.c.max_pk == SuiviProd.pk) &
                          (subquery.c.variable == SuiviProd.variable))))

        for var in compteur:
            if var.variable == "CPT_Goulotte":
                CPT_Goulotte = var.valeur_num
            elif var.variable == "CPT_Coupe":
                CPT_Coupe = var.valeur_num
            elif var.variable == "CPT_BoitePassCP":
                CPT_BoitePassCP = var.valeur_num
            elif var.variable == "CPT_Barillet":
                CPT_Barillet = var.valeur_num
            elif var.variable == "CPT_BoitePassBarillet":
                CPT_BoitePassBarillet = var.valeur_num
            elif var.variable == "CPT_Chargement":
                CPT_Chargement = var.valeur_num
            elif var.variable == "CPT_BoiteStock":
                CPT_BoiteStock = var.valeur_num
            elif var.variable == "CPT_BoitePassPrépaDirecte":
                CPT_BoitePassPrépaDirecte = var.valeur_num
            elif var.variable == "CPT_BoiteRejetDpdE1":
                CPT_BoiteRejetDpdE1 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetDlectE1":
                CPT_BoiteRejetDlectE1 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetErrAxeE1":
                CPT_BoiteRejetErrAxeE1 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetDpsE1":
                CPT_BoiteRejetDpsE1 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetTestE1":
                CPT_BoiteRejetTestE1 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetErrTestE1":
                CPT_BoiteRejetErrTestE1 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetDpdE2":
                CPT_BoiteRejetDpdE2 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetDlectE2":
                CPT_BoiteRejetDlectE2 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetErrAxeE2":
                CPT_BoiteRejetErrAxeE2 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetDpsE2":
                CPT_BoiteRejetDpsE2 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetTestE2":
                CPT_BoiteRejetTestE2 = var.valeur_num
            elif var.variable == "CPT_BoiteRejetErrTestE2":
                CPT_BoiteRejetErrTestE2 = var.valeur_num
            elif var.variable == "API_Nbr_de_Pilulier_Med":
                API_Nbr_de_Pilulier_Med = var.valeur_num
            elif var.variable == "API_Nbr_de_Plateau_Med":
                API_Nbr_de_Plateau_Med = var.valeur_num
            elif var.variable == "API_Nbr_Carnet_Pilulier_Med":
                API_Nbr_Carnet_Pilulier_Med = var.valeur_num
            elif var.variable == "API_Nbr_de_Plateau_Carnet_Med":
                API_Nbr_de_Plateau_Carnet_Med = var.valeur_num
            elif var.variable == "API_Nbr_de_Pilulier_Carnet_Med":
                API_Nbr_de_Pilulier_Carnet_Med = var.valeur_num
            elif var.variable == "API_Nbr_Blister_Charge_Med":
                API_Nbr_Blister_Charge_Med = var.valeur_num
            elif var.variable == "API_Nbr_Goulotte_Chargee_Med":
                API_Nbr_Goulotte_Chargee_Med = var.valeur_num
            elif var.variable == "API_Nbr_Erreur_Goulotte_Med":
                API_Nbr_Erreur_Goulotte_Med = var.valeur_num
            elif var.variable == "API_Nbr_Blister_pris_Med":
                API_Nbr_Blister_pris_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Blister_RB2_Med":
                API_Nbr_Rejet_Blister_RB2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Sachet_RB2_Med":
                API_Nbr_Rejet_Sachet_RB2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_SachetP_RB2_Med":
                API_Nbr_Rejet_SachetP_RB2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Blister_RB1_Med":
                API_Nbr_Rejet_Blister_RB1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Sachet_RB1_Med":
                API_Nbr_Rejet_Sachet_RB1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_SachetP_RB1_Med":
                API_Nbr_Rejet_SachetP_RB1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_DU_Med":
                API_Nbr_Rejet_DU_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Ticket_Med":
                API_Nbr_Rejet_Ticket_Med = var.valeur_num
            elif var.variable == "API_Nbr_Sachet_Pose_Med":
                API_Nbr_Sachet_Pose_Med = var.valeur_num
            elif var.variable == "API_Nbr_SachetP_Pose_Med":
                API_Nbr_SachetP_Pose_Med = var.valeur_num
            elif var.variable == "API_Nbr_DU_Pose_Med":
                API_Nbr_DU_Pose_Med = var.valeur_num
            elif var.variable == "API_Nbr_Ticket_Pose_Med":
                API_Nbr_Ticket_Pose_Med = var.valeur_num
            elif var.variable == "API_Nbr_Sachet_Pose_Carnet_Med":
                API_Nbr_Sachet_Pose_Carnet_Med = var.valeur_num
            elif var.variable == "API_Nbr_SachetP_Pose_Carnet_Med":
                API_Nbr_SachetP_Pose_Carnet_Med = var.valeur_num
            elif var.variable == "API_Nbr_Du_Pose_Carnet_Med":
                API_Nbr_Du_Pose_Carnet_Med = var.valeur_num
            elif var.variable == "API_Nbr_Ticket_Pose_Carnet_Med":
                API_Nbr_Ticket_Pose_Carnet_Med = var.valeur_num
            elif var.variable == "API_Nbr_Carnet_Pose_Med":
                API_Nbr_Carnet_Pose_Med = var.valeur_num
            elif var.variable == "API_Nbr_Coupe_Med":
                API_Nbr_Coupe_Med = var.valeur_num
            elif var.variable == "API_Nbr_BoitePass_RECU_Med":
                API_Nbr_BoitePass_RECU_Med = var.valeur_num
            elif var.variable == "API_Nbr_BoitePass_CP_Med":
                API_Nbr_BoitePass_CP_Med = var.valeur_num
            elif var.variable == "API_Nbr_BoitePass_Barillet_Med":
                API_Nbr_BoitePass_Barillet_Med = var.valeur_num
            elif var.variable == "API_Nbr_Barillet_Med":
                API_Nbr_Barillet_Med = var.valeur_num
            elif var.variable == "API_Nbr_BoiteStock_Med":
                API_Nbr_BoiteStock_Med = var.valeur_num
            elif var.variable == "API_Nbr_BoitePass_PrepaDir_Med":
                API_Nbr_BoitePass_PrepaDir_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Dpd_E1_Med":
                API_Nbr_Rejet_Dpd_E1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Dlect_E1_Med":
                API_Nbr_Rejet_Dlect_E1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Dps_E1_Med":
                API_Nbr_Rejet_Dps_E1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Test_E1_Med":
                API_Nbr_Rejet_Test_E1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_ErrTest_E1_Med":
                API_Nbr_Rejet_ErrTest_E1_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Dpd_E2_Med":
                API_Nbr_Rejet_Dpd_E2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Dlect_E2_Med":
                API_Nbr_Rejet_Dlect_E2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Dps_E2_Med":
                API_Nbr_Rejet_Dps_E2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_Test_E2_Med":
                API_Nbr_Rejet_Test_E2_Med = var.valeur_num
            elif var.variable == "API_Nbr_Rejet_ErrTest_E2_Med":
                API_Nbr_Rejet_ErrTest_E2_Med = var.valeur_num
            elif var.variable == "API_Temps_Chgt_Blister_Med":
                time = var.valeur_num
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_Temps_Chgt_Blister_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_Temps_Dchgt_Plateau_Med":
                time = var.valeur_num
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_Temps_Dchgt_Plateau_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_Temps_Cueil_Pil_Med":
                time = var.valeur_num
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_Temps_Cueil_Pil_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_Temps_Cueil_Carnet_Med":
                time = var.valeur_num
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_Temps_Cueil_Carnet_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_Nbr_Coupe_Heure_Med":
                API_Nbr_Coupe_Heure_Med = var.valeur_num
            elif var.variable == "API_Nbr_RetourProduit_Med":
                API_Nbr_RetourProduit_Med = var.valeur_num
            elif var.variable == "API_Nbr_Dose_Rangee_Med":
                API_Nbr_Dose_Rangee_Med = var.valeur_num
            elif var.variable == "API_Nbr_Dose_Rangee_Heure_Med":
                API_Nbr_Dose_Rangee_Heure_Med = var.valeur_num
            elif var.variable == "API_Temps_Panne_Med":
                time = var.valeur_num
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_Temps_Panne_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_TEMPS_ATTENTE_OPERATEUR_Med":
                time = var.valeur_num/3600
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_TEMPS_ATTENTE_OPERATEUR_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_TEMPS_ATTENTE_ECRAN_Med":
                time = var.valeur_num/3600
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_TEMPS_ATTENTE_ECRAN_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_TEMPS_RESOLUTION_DEFAUT_Med":
                time = var.valeur_num/3600
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_TEMPS_RESOLUTION_DEFAUT_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_TEMPS_UTILISATION_Med":
                time = var.valeur_num/3600
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_TEMPS_UTILISATION_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_TEMPS_CYCLE_REEL_Med":
                time = var.valeur_num/3600
                hours = int(time)
                minutes = (time*60) % 60.
                seconds = (time*3600) % 60.
                API_TEMPS_CYCLE_REEL_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
            elif var.variable == "API_DISPONIBILITE_Med":
                API_DISPONIBILITE_Med = var.valeur_num
            elif var.variable == "API_Nbr_de_Pilulier_heure_Med":
                API_Nbr_de_Pilulier_heure_Med = round(var.valeur_num, 2)
            elif var.variable == "API_Nbr_Carnet_Pilulier_heure_Med":
                API_Nbr_de_Pilulier_Carnet_heure_Med = round(var.valeur_num, 2)

        # if temps_cueillette_pilulier:
        #     Cadence_Pilulier = round(float(API_Nbr_de_Pilulier_Med) / float(temps_cueillette_pilulier),2)
        # else:
        #     Cadence_Pilulier = 0

        # if temps_cueillette_carnet:
        #     Cadence_Carnet = round(float(API_Nbr_Carnet_Pose_Med) / float(temps_cueillette_carnet),2)
        # else:
        #     Cadence_Carnet = 0

        if API_Nbr_de_Pilulier_Med != 0:
            Nb_doses_Pilulier = ((API_Nbr_DU_Pose_Med+API_Nbr_Sachet_Pose_Med+API_Nbr_SachetP_Pose_Med)
                                 / API_Nbr_de_Pilulier_Med)
            Nb_doses_Pilulier = round(Nb_doses_Pilulier, 2)
        else:
            Nb_doses_Pilulier = 0

        if API_Nbr_Carnet_Pilulier_Med != 0:
            Nb_doses_Carnet = ((API_Nbr_Sachet_Pose_Carnet_Med+API_Nbr_SachetP_Pose_Carnet_Med
                               + API_Nbr_Du_Pose_Carnet_Med)/API_Nbr_Carnet_Pilulier_Med)
            Nb_doses_Carnet = round(Nb_doses_Carnet, 2)
        else:
            Nb_doses_Carnet = 0

        return {
            'type_mag': v_mag,
            'CPT_Goulotte': CPT_Goulotte,
            'CPT_Coupe': CPT_Coupe,
            'CPT_BoitePassCP': CPT_BoitePassCP,
            'CPT_Barillet': CPT_Barillet,
            'CPT_BoitePassBarillet': CPT_BoitePassBarillet,
            'CPT_Chargement': CPT_Chargement,
            'CPT_BoiteStock': CPT_BoiteStock,
            'CPT_BoitePassPrépaDirecte': CPT_BoitePassPrépaDirecte,
            'CPT_BoiteRejetDpdE1': CPT_BoiteRejetDpdE1,
            'CPT_BoiteRejetDlectE1': CPT_BoiteRejetDlectE1,
            'CPT_BoiteRejetErrAxeE1': CPT_BoiteRejetErrAxeE1,
            'CPT_BoiteRejetDpsE1': CPT_BoiteRejetDpsE1,
            'CPT_BoiteRejetTestE1': CPT_BoiteRejetTestE1,
            'CPT_BoiteRejetErrTestE1': CPT_BoiteRejetErrTestE1,
            'CPT_BoiteRejetDpdE2': CPT_BoiteRejetDpdE2,
            'CPT_BoiteRejetDlectE2': CPT_BoiteRejetDlectE2,
            'CPT_BoiteRejetErrAxeE2': CPT_BoiteRejetErrAxeE2,
            'CPT_BoiteRejetDpsE2': CPT_BoiteRejetDpsE2,
            'CPT_BoiteRejetTestE2': CPT_BoiteRejetTestE2,
            'CPT_BoiteRejetErrTestE2': CPT_BoiteRejetErrTestE2,
            'API_Nbr_de_Pilulier_Med': API_Nbr_de_Pilulier_Med,
            'API_Nbr_de_Plateau_Med': API_Nbr_de_Plateau_Med,
            'API_Nbr_Carnet_Pilulier_Med': API_Nbr_Carnet_Pilulier_Med,
            'API_Nbr_de_Plateau_Carnet_Med': API_Nbr_de_Plateau_Carnet_Med,
            'API_Nbr_de_Pilulier_Carnet_Med': API_Nbr_de_Pilulier_Carnet_Med,
            'API_Nbr_Blister_Charge_Med': API_Nbr_Blister_Charge_Med,
            'API_Nbr_Goulotte_Chargee_Med': API_Nbr_Goulotte_Chargee_Med,
            'API_Nbr_Erreur_Goulotte_Med': API_Nbr_Erreur_Goulotte_Med,
            'API_Nbr_Blister_pris_Med': API_Nbr_Blister_pris_Med,
            'API_Nbr_Rejet_Blister_RB2_Med': API_Nbr_Rejet_Blister_RB2_Med,
            'API_Nbr_Rejet_Sachet_RB2_Med': API_Nbr_Rejet_Sachet_RB2_Med,
            'API_Nbr_Rejet_SachetP_RB2_Med': API_Nbr_Rejet_SachetP_RB2_Med,
            'API_Nbr_Rejet_Blister_RB1_Med': API_Nbr_Rejet_Blister_RB1_Med,
            'API_Nbr_Rejet_Sachet_RB1_Med': API_Nbr_Rejet_Sachet_RB1_Med,
            'API_Nbr_Rejet_SachetP_RB1_Med': API_Nbr_Rejet_SachetP_RB1_Med,
            'API_Nbr_Rejet_DU_Med': API_Nbr_Rejet_DU_Med,
            'API_Nbr_Rejet_Ticket_Med': API_Nbr_Rejet_Ticket_Med,
            'API_Nbr_Sachet_Pose_Med': API_Nbr_Sachet_Pose_Med,
            'API_Nbr_SachetP_Pose_Med': API_Nbr_SachetP_Pose_Med,
            'API_Nbr_DU_Pose_Med': API_Nbr_DU_Pose_Med,
            'API_Nbr_Ticket_Pose_Med': API_Nbr_Ticket_Pose_Med,
            'API_Nbr_Sachet_Pose_Carnet_Med': API_Nbr_Sachet_Pose_Carnet_Med,
            'API_Nbr_SachetP_Pose_Carnet_Med': API_Nbr_SachetP_Pose_Carnet_Med,
            'API_Nbr_Du_Pose_Carnet_Med': API_Nbr_Du_Pose_Carnet_Med,
            'API_Nbr_Ticket_Pose_Carnet_Med': API_Nbr_Ticket_Pose_Carnet_Med,
            'API_Nbr_Carnet_Pose_Med': API_Nbr_Carnet_Pose_Med,
            'API_Nbr_Coupe_Med': API_Nbr_Coupe_Med,
            'API_Nbr_BoitePass_RECU_Med': API_Nbr_BoitePass_RECU_Med,
            'API_Nbr_BoitePass_CP_Med': API_Nbr_BoitePass_CP_Med,
            'API_Nbr_BoitePass_Barillet_Med': API_Nbr_BoitePass_Barillet_Med,
            'API_Nbr_Barillet_Med': API_Nbr_Barillet_Med,
            'API_Nbr_BoiteStock_Med': API_Nbr_BoiteStock_Med,
            'API_Nbr_BoitePass_PrepaDir_Med': API_Nbr_BoitePass_PrepaDir_Med,
            'API_Nbr_Rejet_Dpd_E1_Med': API_Nbr_Rejet_Dpd_E1_Med,
            'API_Nbr_Rejet_Dlect_E1_Med': API_Nbr_Rejet_Dlect_E1_Med,
            'API_Nbr_Rejet_Dps_E1_Med': API_Nbr_Rejet_Dps_E1_Med,
            'API_Nbr_Rejet_Test_E1_Med': API_Nbr_Rejet_Test_E1_Med,
            'API_Nbr_Rejet_ErrTest_E1_Med': API_Nbr_Rejet_ErrTest_E1_Med,
            'API_Nbr_Rejet_Dpd_E2_Med': API_Nbr_Rejet_Dpd_E2_Med,
            'API_Nbr_Rejet_Dlect_E2_Med': API_Nbr_Rejet_Dlect_E2_Med,
            'API_Nbr_Rejet_Dps_E2_Med': API_Nbr_Rejet_Dps_E2_Med,
            'API_Nbr_Rejet_Test_E2_Med': API_Nbr_Rejet_Test_E2_Med,
            'API_Nbr_Rejet_ErrTest_E2_Med': API_Nbr_Rejet_ErrTest_E2_Med,
            'API_Temps_Chgt_Blister_Med': API_Temps_Chgt_Blister_Med,
            'API_Temps_Dchgt_Plateau_Med': API_Temps_Dchgt_Plateau_Med,
            'API_Temps_Cueil_Pil_Med': API_Temps_Cueil_Pil_Med,
            'API_Temps_Cueil_Carnet_Med': API_Temps_Cueil_Carnet_Med,
            'API_Nbr_Coupe_Heure_Med': API_Nbr_Coupe_Heure_Med,
            'API_Nbr_RetourProduit_Med': API_Nbr_RetourProduit_Med,
            'API_Nbr_Dose_Rangee_Med': API_Nbr_Dose_Rangee_Med,
            'API_Nbr_Dose_Rangee_Heure_Med': API_Nbr_Dose_Rangee_Heure_Med,
            'API_Temps_Panne_Med': API_Temps_Panne_Med,
            'API_TEMPS_ATTENTE_OPERATEUR_Med': API_TEMPS_ATTENTE_OPERATEUR_Med,
            'API_TEMPS_ATTENTE_ECRAN_Med': API_TEMPS_ATTENTE_ECRAN_Med,
            'API_TEMPS_RESOLUTION_DEFAUT_Med': API_TEMPS_RESOLUTION_DEFAUT_Med,
            'API_TEMPS_UTILISATION_Med': API_TEMPS_UTILISATION_Med,
            'API_TEMPS_CYCLE_REEL_Med': API_TEMPS_CYCLE_REEL_Med,
            'API_DISPONIBILITE_Med': API_DISPONIBILITE_Med,
            'Cadence_Pilulier': API_Nbr_de_Pilulier_heure_Med,
            'Cadence_Carnet': API_Nbr_de_Pilulier_Carnet_heure_Med,
            'Nb_doses_Pilulier': Nb_doses_Pilulier,
            'Nb_doses_Carnet': Nb_doses_Carnet
        }
