from flask_restful import Resource, reqparse
from median.models import Product, Historique
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('fonction')
parser.add_argument('ref')


class ApiSuggestions_UCD_Lot_Histo(Resource):

    def get(self):
        args = parser.parse_args()
        v_fonction = args['fonction']
        v_search_ref = args['ref'].replace(' ', '%')

        try:
            if v_fonction == 'ref':
                product = (
                    Product.select(Product.reference, Product.designation)
                    .where(Product.reference == v_search_ref))

                return ([{
                    'value': p.reference,
                    'text': p.designation
                } for p in product])
            elif v_fonction == 'ucd':
                ucd = (Historique.select(Historique.ucd).distinct().where(
                    (Historique.reference == v_search_ref) & (Historique.ucd != '')
                    & (Historique.ucd != '3,40089E+12')))

                return ([{
                    'value': p.ucd,
                } for p in ucd])
            elif v_fonction == 'lot':
                lot = (Historique.select(Historique.lot).distinct().where(
                    (Historique.reference == v_search_ref) & (Historique.lot != '')))

                return ([{
                    'value': p.lot,
                } for p in lot])

        except Exception as error:
            return {'message': error.args}, 400
