from flask_restful import reqparse
from flask_restful import Resource
from median.models import Magasin, Endpoint
from median.utils import logger
from peewee import DoesNotExist


class ApiRiedlEquipment(Resource):

    def get(self, poste=None):
        """If poste is None, return all Riedl equipment"""
        parser = reqparse.RequestParser()
        parser.add_argument('poste')
        if poste is None:
            mags = Magasin.select(Magasin).where(Magasin.eco_type == 'L')
            logger.info("%i Riedl found" % len(mags))
            return [{
                'pk': m.pk,
                'mag': m.mag,
                'type_mag': m.type_mag,
                'eco_type': m.eco_type,
                'id_zone': m.id_zone,
                'id_robot': m.id_robot,
            } for m in mags]
        else:
            try:
                m = Magasin.get(type_mag=poste)
                logger.info("Riedl %s found" % m.mag)
                return {
                    'pk': m.pk,
                    'mag': m.mag,
                    'type_mag': m.type_mag,
                    'eco_type': m.eco_type,
                    'id_zone': m.id_zone,
                    'id_robot': m.id_robot,
                }
            except DoesNotExist:
                logger.error('Riedl [%s] not found' % poste)
                return {'message': 'Riedl [%s] not found' % poste}, 404


class ApiRiedlEndpoint(Resource):

    def get(self, poste=None):
        try:
            if poste is None:
                enp = Endpoint.select(Endpoint).where(Endpoint.type_dest == 'RIEDL')
            else:
                enp = Endpoint.select(Endpoint).where(Endpoint.type_dest == 'RIEDL', Endpoint.secteur == poste)

            res = [{
                'pk': e.pk,
                'code': e.code,
                'label': e.libelle,
                'riedl': e.secteur,
                'priority': e.ordre,
                'exit': e.type_peigne,
            } for e in enp]

            if len(res) == 0:
                logger.error('Endpoint for Riedl [%s] not found' % poste)
                return {'message': 'Endpoint for Riedl [%s] not found' % poste}, 404

            return res
        except DoesNotExist:
            logger.error('Endpoint for Riedl [%s] not found' % poste)
            return {'message': 'Endpoint for Riedl [%s] not found' % poste}, 404

    def post(self):
        """Create a new endpoints"""
        return {'message': 'ApiRiedlEndpoint::post not implemented'}, 405

    def put(self):
        """Update an Endpoints"""
        return {'message': 'ApiRiedlEndpoint::put not implemented'}, 405

    def delete(self):
        return {'message': 'ApiRiedlEndpoint::delete not implemented'}, 405
