from flask import request
from flask_restful import Resource, reqparse
from median.models import Config, FListe, Magasin, FItem
from median.constant import TypeServiListe
from median.views.parameter import RawConfig
from median.views import Seuil
from common.util import logger
from median.base import BaseViewException
from peewee import DoesNotExist

import datetime

parser = reqparse.RequestParser()
parser.add_argument('liste')
parser.add_argument('ref')
parser.add_argument('fraction')
parser.add_argument('quantite')
parser.add_argument('pk_item')
parser.add_argument('qte_dem')


class ApiReappro(Resource):

    def _transfert_service(self,):
        """Retrieve teh code of the service to transfert stock"""
        service = RawConfig().read(param='k_ua_transfert').value
        # if service is None:
        #     raise BaseViewException("k_ua_transfet n'est pas définit")

        return service

    def _check_type_magasin(self, type_magas):
        """Check if magasin exists

        :param type_magas: code magasin a rechercher
        :type  type_magas: str
        :return: Magasin model
        :rtype: median.models.Magasin
        """
        try:
            m = Magasin.get(type_mag=type_magas)
        except DoesNotExist:
            logger.error("Le type magasin %s n'existe pas" % type_magas)
            raise BaseViewException("Le magasin n'existe pas dans la base")
        return m

    def get(self):

        # n = Config.select(Config.value).where(Config.cle == 'CPT_LISTE_E' & Config.poste == 'TOUS')

        n = Config.get(poste='TOUS', cle='CPT_LISTE_S')

        c = str(int(n.value) + 1)

        Config.update({Config.value: c}).where((Config.poste == 'TOUS') & (Config.cle == 'CPT_LISTE_S')).execute()

        return c.zfill(5)

    def post(self):
        logger.info("ApiReappro::post")
        res = request.get_json(force=True)
        logger.info(res)

        liste = res["liste"]
        type_magasin = res["type_magasin"]
        gpao = res["gpao"]

        service = self._transfert_service()
        mag = self._check_type_magasin(type_magasin)

        # Création de la liste d'entrée
        if len(res["lines"]) > 0:
            FListe.create(
                liste=liste, date_creation=datetime.datetime.now(), etat='V',
                mode='E', fusion='REASSORT', service=service,
                date_modification=datetime.datetime.now(), zone_fin=type_magasin,
                type_servi=TypeServiListe.GlobaleBoite.value, id_servi=2,
                nb_item=len(res["lines"])
            )

        # Création des items
        for r in res["lines"]:
            Seuil().reappro_item(liste, r["item"], r["ref"], r["frac"], r["qte"], type_magasin, service)

        # Création f_gpao
        if gpao == "1":
            Seuil().creer_gpao(mag.id_zone)

        return "ok"

    def delete(self):
        args = parser.parse_args()
        _pk = args['pk_item']
        logger.info("Suppression de l'item %s d'une liste d'entrée" % _pk)

        try:

            FItem.delete().where(FItem.pk == _pk).execute()

            logger.info("Suppression réussie de l'item %s d'une liste d'entrée" % _pk)
            return {'message': 'Success', 'id': None}

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400


class ApiReapproItem(Resource):

    def post(self):
        args = parser.parse_args()
        _pk = args['pk_item']
        _qte_dem = args['qte_dem']

        # Mise à jour de l'item
        FItem.update({FItem.qte_dem: _qte_dem}).where(FItem.pk == _pk).execute()

        return "ok"
