from flask_restful import Resource, reqparse
from median.models import Adresse
from peewee import DoesNotExist, fn
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('ref')
parser.add_argument('champ')
parser.add_argument('adresse')
parser.add_argument('tiroir_bas')


class ApiProductParam(Resource):

    def put(self, ref):

        args = parser.parse_args()
        adresse = args['adresse'] + '%'
        # tiroir_bas = args['tiroir_bas']

        logger.info('Edition de produit, ref: "%s"' % (ref))
        try:
            n = (Adresse
                 .update({Adresse.emplacement: ref})
                 .where(Adresse.adresse % adresse))
            n.execute()

        except DoesNotExist:
            logger.error('Ce produit n\'existe pas! Réf: "%s"' % (ref))
            return {'message': 'Product does not exist'}, 404
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503

        logger.info('Le produit a été modifié sans problème. Réf: "%s"' % (ref))
        return 'Success'

    # def post(self, ref=None):

    #     args = parser.parse_args()
    #     _ref = args['ref']
    #     _champ = args['champ']
    #     _tiroir_bas = args['tiroir_bas']

    # logger.info('Création de produit, ref: "%s"' % (_ref))

    # if _ref:
    #     if not self._isProductReferenceAvailable(_ref):
    #         logger.warning('La référence existe déjà')
    #         return {'status': 'Error', 'ref': _ref}
    # else:
    #     logger.info('On crée une nouvelle référence')
    #     _ref = self._generateProductReference()

    # logger.info('On crée le produit en base, ref: "%s", designation: "%s",'
    #             ' com_med: "%s"', (_ref, _designation, _com_med))
    # Product.create(reference=_ref,
    #                designation=_designation,
    #                com_med=_com_med)

    # return {'status': 'Success', 'ref': _ref}

    def get(self, ref):

        try:
            a = (Adresse
                 .select(fn.substr(Adresse.adresse, 1, 11).alias('adr'))
                 .where(Adresse.emplacement == ref)
                 .group_by(fn.substr(Adresse.adresse, 1, 11)))

        except DoesNotExist:
            logger.error('Le produit n\'existe pas => Réf: "%s"' % (ref))
            return {'message': 'Product does not exist'}, 404
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503

        _out = []

        for m in a:
            _out.append({
                    'adr': m.adr,
                })

        return _out

    # def _GetProductStockInfo(self, ref):

    #     st = (Product
    #           .select(Product, fn.SUM(Stock.quantite).alias('stock'))
    #           .join(Stock, on=(Product.reference == Stock.reference))
    #           .where(Product.reference == ref)
    #           .group_by(Product))

    #     if not st:
    #         stock = 0
    #     else:
    #         stock = st[0].stock

    #     s = (Product
    #          .select(Product,
    #                  fn.SUM(Seuil.stock_mini).alias('stock_mini'),
    #                  fn.SUM(Seuil.stock_maxi).alias('stock_maxi'))
    #          .join(Seuil, on=(Product.reference == Seuil.reference))
    #          .group_by(Product))

    #     return {
    #         'stock': stock,
    #         'stock_mini': s and s[0].stock_mini or '-',
    #         'stock_maxi': s and s[0].stock_maxi or '-'
    #     }

    # def _getStockByMagasin(self, ref):

    #     mags = (Magasin
    #             .select(Magasin.mag, Magasin.type_mag, fn.SUM(Stock.quantite).alias('stock'))
    #             .join(Stock, JOIN.LEFT_OUTER, on=((ref == Stock.reference) & (Magasin.mag == Stock.magasin)))
    #             # .where(Magasin.eco_type == 'C')
    #             .group_by(Magasin.mag))

    #     _out = []
    #     for m in mags:
    #         if m.type_mag != 'RETOUR':
    #             q = (FListe.select((fn.SUM(FItem.qte_dem - FItem.qte_serv)).alias('cmd')).join(
    #                      FItem, on=(
    #                          (FListe.liste == FItem.liste)
    #                          & (FListe.mode == FItem.mode)
    #                          & (FItem.reference == ref)))
    #                     .where(  # noqa
    #                          (FListe.mode == 'E')
    #                          & (FListe.etat == 'V')
    #                          & (FListe.zone_fin == m.type_mag))
    #                     .group_by(FListe.zone_fin))

    #             cmd = q and q[0].cmd or 0
    #             if cmd < 0:
    #                 cmd = 0
    #             _out.append({
    #                 'mag': m.mag,
    #                 'type_mag': m.type_mag,
    #                 'stock': m.stock or 0,
    #                 'commande': cmd or 0,
    #             })

    #     return _out

    # def _generateProductReference(self):
    #     while True:
    #         rand_ref = 'P' + str(round(random.random()*100000000))
    #         if self._isProductReferenceAvailable(rand_ref):
    #             break
    #     return rand_ref

    # def _isProductReferenceAvailable(self, ref):
    #     if (Product.select(Product.reference)
    #                .where(Product.reference == ref)
    #                .count()) == 0:
    #         return True
    #     return False

    # def _getProductUCDAndCIPListJSON(self, ref):
    #     _out = []

    #     ucd_list = (Ucd.select(Ucd.ucd)
    #                 .distinct()
    #                 .where(Ucd.reference == ref)
    #                 .order_by(Ucd.ucd))

    #     for u in ucd_list:
    #         ucd_cip_list = Cip.select(Cip.ucd, Cip.cip).distinct().where(Cip.ucd == u.ucd)
    #         logger.info('Lines : %s.' % len(ucd_cip_list))
    #         _o = {
    #             'text': '<b>UCD</b>: ' + u.ucd,
    #             'children': []
    #         }
    #         for c in ucd_cip_list:
    #             _o['children'].append('<b>CIP</b>: ' + c.cip)
    #         _out.append(_o)

    #     return _out
