from flask_restful import reqparse
from flask_restful import Resource
from median.models import Magasin, Adresse, Compteur
from median.utils import logger
from peewee import DoesNotExist

parser = reqparse.RequestParser()
parser.add_argument('adr')
parser.add_argument('type')


class ApiMagasin(Resource):

    def get(self):
        try:

            mags = (Magasin.select().order_by(Magasin.type_mag))

        except Exception as error:
            logger.error('erreur recuperation magasin')
            return {'message': error.args}, 400

        logger.info('Lines : %s.' % len(mags))
        return ([{
            'pk': m.pk,
            'mag': m.mag,
            'type_mag': m.type_mag,
            'eco_type': m.eco_type,
            'libelle': m.libelle,
            'type_machine': m.type_machine
        } for m in mags])

    def put(self):
        args = parser.parse_args()
        adr = args['adr']
        type = args['type']

        logger.info('Création/Suppression contenant: "%s"' % (adr))

        if not adr:
            logger.warning('Adresse manquante!')
            return 'Adresse manquante!'

        try:

            if (type == 'suppression'):
                n = (Adresse
                     .update({Adresse.contenant: ''})
                     .where(Adresse.adresse == adr))
                n.execute()
            else:
                n = (Compteur.select().where(Compteur.cle == 'CONTENANT_PASS'))

                n.execute()

                c = str(n[0].val)

                logger.info('Création/Suppression contenant: "%s"' % (adr))
                # logger.info('Contenant : "%s"' % (c.zfill(9)))

                m = (Adresse
                     .update({Adresse.contenant: c.zfill(9)})
                     .where(Adresse.adresse == adr))

                m.execute()

                m = (Compteur
                     .update({Compteur.val: n[0].val + 1})
                     .where(Compteur.cle == 'CONTENANT_PASS'))

                m.execute()

        except DoesNotExist:
            logger.error('Ce produit n\'existe pas! Réf: "%s"' % (adr))
            return {'message': 'Product does not exist'}, 404
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503

        logger.info("""L'adresse a été modifié sans problème. Réf: "%s" """ % (adr))
        return 'Success'
