from flask_restful import Resource
from median.models import Stock
import logging

logger = logging.getLogger('median.webserver')


class ApiLots(Resource):

    def get(self, ucd):
        try:
            _lots = (Stock.select(Stock.lot).distinct().where(Stock.ucd == ucd).order_by(Stock.date_entree))
            logger.info('Lines : %s.' % len(_lots))
            return ([{
                'lot': lo.lot
            } for lo in _lots])

        except Exception as error:
            return {'message': error.args}, 503
