from flask_restful import Resource, reqparse
# from flask import session
from median.models import FListe, FItem
from common.util import logger
# from peewee import fn

parser = reqparse.RequestParser()
parser.add_argument('pk')
parser.add_argument('item')


class ApiListesSortiesItems(Resource):

    def get(self):
        logger.info("Récupérer les listes de sorties...")
        lis = FListe.select(FListe.pk, FListe.liste).where(FListe.mode == 'S')
        ucd_cip_list = self._getProductUCDAndCIPListJSON()
        logger.info('Récupérer les listes de sorties... %s' % lis.count())
        return {
               'ucd_cip_list': ucd_cip_list
        }

    def delete(self):
        args = parser.parse_args()
        _pk = args['pk']
        _item = args['item']
        logger.info("Suppression des items d'une liste de sorties: %s" % _pk)

        try:

            # get list label (needed to fetch items)
            _l = FListe.select(FListe.liste).where(FListe.liste == _pk)

            if len(_l) == 0:
                logger.error("Liste de sorties non trouvée: %s" % _pk)
                return {'message': "Liste de sorties non trouvée!"}, 503

            FItem.delete().where((FItem.liste == _pk) & (FItem.mode == 'S') & (FItem.item == _item)).execute()

            logger.info("Suppression réussie d'une liste de sorties: %s" % _pk)
            return {'message': 'Success', 'id': None}

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 400

    def _getProductUCDAndCIPListJSON(self):
        _out = []

        ucd_list = (FListe.select(FListe.service, FListe.fusion).distinct().where(
            FListe.mode == 'S').order_by(FListe.service))

        for u in ucd_list:
            ucd_cip_list = FListe.select(FListe.pk, FListe.liste, FListe.service).where(FListe.service == u.service)
            logger.info('Lines : %s.' % len(ucd_cip_list))
            _o = {
                'text': '<b>'+u.fusion+'</b>',
                'id': u.service,
                'children': []
            }
            for c in ucd_cip_list:
                _o['children'].append(c.liste)
            _out.append(_o)

        return _out
