from flask_restful import Resource, reqparse
# from flask import session
from median.models import LotRetire, Stock, Dispensation, DispensationItem
from median.constant import TypeServiListe
from median.views import RawConfig
from peewee import fn
import logging
import datetime

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('ucd')
parser.add_argument('lot')


class ApiListeSorties(Resource):

    def post(self, ref):

        logger.info("Création d'une liste de sortie de lots retirés...")

        args = parser.parse_args()
        _ucd = args['ucd']
        _lot = args['lot']

        try:
            # récupérer les produits en stock ayant ce numéro de lot
            refs_in_stock = (
                Stock.select(
                    Stock.reference,
                    Stock.fraction,
                    fn.SUM(Stock.quantite).alias('quantite'))
                .where(((Stock.reference == ref) | (Stock.ucd == _ucd)) & (Stock.lot == _lot))
                .group_by(Stock.reference))
            if refs_in_stock.count() == 0:
                return {'message': "Il n'y a pas de produits en stock ayant ce numéro de lot."}, 503

            # vérifier que le lot en question est bien un lot à retirer
            lo = (
                LotRetire.select()
                .where((LotRetire.ucd == _ucd) & (LotRetire.lot == _lot))
                )
            if lo.count() == 0:
                return {'message': "Ce lot n'a pas été marqué comme étant à retirer."}, 503

            # chercher l'id dans f_dest dont le libellé = "SORTIE DE LOTS"
            # peut faire mieux, dans la version finale
            try:
                service = RawConfig().read(param='k_ua_pui').value
            except Exception as error:
                logger.error(error.args)
                return {'message': "k_ua_pui n'est pas définit."}, 503
            # serv = (
            #     Service.select(Service.code)
            #     .where(Service.libelle == 'SORTIE DE LOTS')
            # )
            # if serv.count() == 0:
            #     return {'message': "Service non trouvé, veuillez contactez la maintenance Ecodex."}, 503

            liste_label = "LOT A SORTIR " + _lot

            _existing_disp = (
                Dispensation.select()
                .where(Dispensation.liste == liste_label)
                )
            if _existing_disp.count():
                return {'message': "Une liste de sortie a déjà été créée pour ce lot."}, 503

            Dispensation.create(
                fusion="SORTIE DE LOTS",
                liste=liste_label,
                mode="S",
                service=service,
                type_servi=TypeServiListe.GlobaleBoite.value,
                id_servi=2,
                nb_item=refs_in_stock.count(),
                etat='V',
                date_creation=datetime.datetime.now(),
                num_ipp='GLOBAL',
                num_sej='GLOBAL',
            )

            for r in refs_in_stock:
                DispensationItem.create(
                    liste=liste_label,
                    item='000001',
                    mode="S",
                    reference=r.reference,
                    qte_dem=r.quantite,
                    fraction=r.fraction,
                    lot=_lot,
                    dest=service,
                    type_servi=TypeServiListe.GlobaleBoite.value,
                    id_servi=2,
                    etat='V'
                )

            logger.info('Création d\'une liste de sortie de lots à retirer... REUSSI')
            return 'Success'

        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503
