from flask_restful import reqparse
# from flask import session
from median.models import Seuil, Stock, Magasin, Dispensation, DispensationItem, Zone, ZoneMag
from peewee import DoesNotExist, fn
import logging
from common.rest import DataTables

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('product_ref')
parser.add_argument('select')
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Start parameter for Datatables')
parser.add_argument('length', type=int, help='Limit parameter for Datatables')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument('mag')
parser.add_argument('fraction')
parser.add_argument('seuil_min')
parser.add_argument('seuil_max')
parser.add_argument('quantite')
parser.add_argument('en_commande')
parser.add_argument('pk')


class DatatableSeuils(DataTables):

    def post(self, ref):
        args = parser.parse_args()
        v_draw = args['draw']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']

        try:
            total_seuils_count = (
                Seuil.select()
                .where(Seuil.reference == ref)
                .count())
            filtered_seuils_query = (
                Seuil.select().where(Seuil.reference == ref))

            if (v_orderby == 1):
                v_orderby_column = Seuil.zone
            elif (v_orderby == 2):
                v_orderby_column = Seuil.fraction
            elif (v_orderby == 3):
                v_orderby_column = Seuil.stock_mini
            elif (v_orderby == 4):
                v_orderby_column = Seuil.stock_maxi
            else:
                v_orderby_column = Seuil.zone

            if (v_dir == 'desc'):
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            filtered_seuils = (filtered_seuils_query
                               .order_by(v_orderby_column_dir))

            logger.debug('Lines : %s.' % len(filtered_seuils))

            return self.render([{
                'pk': s.pk,
                'mag': s.zone,
                'fraction': s.fraction,
                'seuil_min': s.stock_mini,
                'seuil_max': s.stock_maxi,
                'quantite': self._get_seuil_quantite(ref, s.fraction, s.zone),
                'commande': self._get_seuil_commande(ref, s.fraction, s.stock_maxi, s.zone),
                'en_commande': (0 if self._get_seuil_quantite(ref, s.fraction, s.zone) +
                                self._get_seuil_commande(ref, s.fraction, s.stock_maxi, s.zone) >= s.stock_mini
                                else s.stock_maxi - self._get_seuil_quantite(ref, s.fraction, s.zone) +
                                self._get_seuil_commande(ref, s.fraction, s.stock_maxi, s.zone))

            } for s in filtered_seuils],
                v_draw,
                total_seuils_count,
                filtered_seuils.count())

        except DoesNotExist:
            logger.error('Get Seuils raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error('Get Seuils raised an exception: ', error.args)
            return self.render([], v_draw, 0, 0, error.args)

    def _get_seuil_quantite(self, ref, fraction, poste):
        _mag = self._get_mag(poste)
        if _mag == '-':
            return '-'
        _q = (
                Stock.select(fn.SUM(Stock.quantite).alias('qte'))
                .where((Stock.reference == ref) & (Stock.fraction == fraction) & (Stock.magasin == _mag)))

        stk = Stock().select(fn.SUM(
            Stock.quantite).alias("total")).join(ZoneMag, on=(Stock.magasin == ZoneMag.mag)).join(
            Zone, on=((Zone.zone == ZoneMag.zone) & (Zone.appro == 1))).where(
            Stock.zone_admin == poste, Stock.reference == ref, Stock.fraction == fraction)

        return ((_q[0].qte or 0) + (stk[0].total or 0))

    def _get_seuil_commande(self, ref, fraction, stock_maxi, poste):
        _mag = self._get_mag(poste)
        if _mag == '-':
            return '-'

        # calcul des quantités déjà en commande
        q = (Dispensation.select(
            (fn.SUM(DispensationItem.qte_dem - DispensationItem.qte_serv)).alias('cmd')).join(
                    DispensationItem, on=(
                        (Dispensation.liste == DispensationItem.liste)
                        & (Dispensation.mode == DispensationItem.mode)
                        & (fraction == DispensationItem.fraction)
                        & (DispensationItem.reference == ref)))
                .where(  # noqa
                        (Dispensation.mode == 'E')
                        & (Dispensation.zone_fin == poste))
                .group_by(Dispensation.zone_fin))

        qty_in_list = 0 if not q else q[0].cmd
        if qty_in_list < 0:
            qty_in_list = 0
        return qty_in_list

    def _get_mag(self, type_mag):
        _m = Magasin.select(Magasin.mag).where(Magasin.type_mag == type_mag)
        if len(_m) == 0:
            return '-'
        return _m[0].mag
