from flask_restful import reqparse
from common.rest import DataTables
# from flask import session
from peewee import DoesNotExist
from common.util import logger
from median.views import Items

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')


class DataTableListeSortiesItems(DataTables):

    def post(self, pk_liste):

        args = parser.parse_args()
        v_draw = args['draw']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']

        logger.info("Récupérer les items de listes de sorties de la liste : '%s'" % pk_liste)

        try:

            if (v_orderby == 1):
                v_orderby_column = "x_item"
            elif (v_orderby == 2):
                v_orderby_column = "x_etat"
            elif (v_orderby == 3):
                v_orderby_column = "x_ref"
            elif (v_orderby == 4):
                v_orderby_column = "x_fraction"
            elif (v_orderby == 5):
                v_orderby_column = "x_desig"
            elif (v_orderby == 6):
                v_orderby_column = "x_qte_dem"
            elif (v_orderby == 7):
                v_orderby_column = "x_qte_serv"
            elif (v_orderby == 8):
                v_orderby_column = "x_moment"
            elif (v_orderby == 9):
                v_orderby_column = "x_heure"
            else:
                v_orderby_column = "x_item"

            if (v_dir != 'desc'):
                v_dir = 'asc'

            _items = Items()
            _items = _items.affichage(pk_liste, v_orderby_column, v_dir)

            if len(_items) == 0:
                logger.error('No list for id %s' % pk_liste)
                return self.render([], v_draw, 0, 0)

            return self.render([{
                'pk': i['x_pk'],
                'item': i['x_item'],
                'etat': self._get_etat_human_label(i['x_etat']),
                'reference': i['x_ref'],
                'fraction': i['x_fraction'],
                'designation': i['x_desig'],
                'qte_demandee': i['x_qte_dem'],
                'qte_servie': i['x_qte_serv'],
                'moment': i['x_moment'],
                'heure': i['x_heure']
            } for i in _items], v_draw, 0, 0)

        except DoesNotExist:
            logger.error('Get reappro items Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error(('Get reappro items Datatables raised an exception: ', error.args))
            return self.render([], v_draw, 0, 0, error.args)

    def _get_etat_human_label(self, etat_short_label):
        options = {
            'V': 'Vierge',
            'E': 'Entamé',
            'S': 'Soldé'
        }
        return options.get(etat_short_label, 'Inconnu')
