from flask_restful import reqparse
from common.rest import DataTables
from peewee import DoesNotExist, JOIN, fn
from common.util import logger
from median.models import Historique, Product, Patient
import operator
from functools import reduce
import xlsxwriter
from flask import send_file
from sqlalchemy import create_engine
import os
import uuid
from pathlib import Path

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument('date_debut')
parser.add_argument('date_fin')
parser.add_argument('reference')
parser.add_argument('type_mouvement')
parser.add_argument('fraction')
parser.add_argument('service')
parser.add_argument('magasin')
parser.add_argument('ucd')
parser.add_argument('lot')
parser.add_argument('adresse')
parser.add_argument('serial')
parser.add_argument('contenant')
parser.add_argument('utilisateur')
parser.add_argument('ipp')
parser.add_argument('patient')
parser.add_argument('liste')
parser.add_argument('pilulier')
parser.add_argument('colvisible')
parser.add_argument('orderby')
parser.add_argument('dir')


class DataTableHistorique(DataTables):

    def post(self):

        args = parser.parse_args()
        v_draw = args['draw']
        v_limit = args['length']
        v_offset = args['start']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']
        v_date_debut = args['date_debut']
        v_date_fin = args['date_fin']
        v_reference = args['reference']
        v_type_mouvement = args['type_mouvement']
        v_fraction = args['fraction']
        v_service = args['service']
        v_magasin = args['magasin']
        v_ucd = args['ucd']
        v_lot = args['lot']
        v_adresse = args['adresse']
        v_serial = args['serial']
        v_contenant = args['contenant']
        v_utilisateur = args['utilisateur']
        v_ipp = args['ipp']
        v_patient = args['patient']
        v_liste = args['liste']
        v_pilulier = args['pilulier']

        if (v_date_debut == '') or (v_type_mouvement is None):
            return self.render([{
                'chrono': '',
                'reference': '',
                'designation': '',
                'fraction': '',
                'type_mouvement': '',
                'adresse': '',
                'adresse_from': '',
                'quantite_mouvement': '',
                'quantite_prescrite': '',
                'quantite_totale': '',
                'info': '',
                'liste': '',
                'service': '',
                'patient': '',
                'pilulier': '',
                'lot': '',
                'ucd': '',
                'utilisateur': '',
                'poste': '',
                'date_peremption': '',
                'serial': '',
                'contenant': ''
            }], v_draw, 0, 0)

        logger.info("Récupérer l'historique")

        try:

            if (v_orderby == 0):
                v_orderby_column = Historique.chrono
            elif (v_orderby == 1):
                v_orderby_column = Historique.reference
            elif (v_orderby == 2):
                v_orderby_column = Product.designation
            elif (v_orderby == 3):
                v_orderby_column = Historique.fraction
            elif (v_orderby == 4):
                v_orderby_column = Historique.type_mouvement
            elif (v_orderby == 5):
                v_orderby_column = Historique.adresse
            elif (v_orderby == 6):
                v_orderby_column = Historique.adresse_from
            elif (v_orderby == 7):
                v_orderby_column = Historique.quantite_mouvement
            elif (v_orderby == 8):
                v_orderby_column = Historique.quantite_prescrite
            elif (v_orderby == 9):
                v_orderby_column = Historique.quantite_totale
            elif (v_orderby == 10):
                v_orderby_column = Historique.info
            elif (v_orderby == 11):
                v_orderby_column = Historique.liste
            elif (v_orderby == 12):
                v_orderby_column = Historique.service
            elif (v_orderby == 13):
                v_orderby_column = Patient.nom
            elif (v_orderby == 14):
                v_orderby_column = Historique.id_pilulier
            elif (v_orderby == 15):
                v_orderby_column = Historique.lot
            elif (v_orderby == 16):
                v_orderby_column = Historique.ucd
            elif (v_orderby == 17):
                v_orderby_column = Historique.utilisateur
            elif (v_orderby == 18):
                v_orderby_column = Historique.poste
            elif (v_orderby == 19):
                v_orderby_column = Historique.date_peremption
            elif (v_orderby == 20):
                v_orderby_column = Historique.serial
            elif (v_orderby == 21):
                v_orderby_column = Historique.contenant
            else:
                v_orderby_column = Historique.chrono

            if (v_dir == 'desc'):
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            if v_type_mouvement:
                ms = v_type_mouvement.split(",")
            # mf = v_format.split(",")

            expr_list = [
                (Historique.chrono >= v_date_debut),
                (Historique.chrono <= v_date_fin),
                ]

            if (v_reference != ''):
                expr_list.append(Product.reference == v_reference)
            if (v_ucd != '') and (v_ucd != 'Tous'):
                expr_list.append(Historique.ucd.contains(v_ucd))
            if (v_lot != '') and (v_lot != 'Tous'):
                expr_list.append(Historique.lot == v_lot)
            if (v_adresse != ''):
                expr_list.append(Historique.adresse.contains(v_adresse))
            if (v_serial != ''):
                expr_list.append(Historique.serial.contains(v_serial))
            if (v_contenant != ''):
                expr_list.append(Historique.contenant.contains(v_contenant))
            if (v_utilisateur != ''):
                expr_list.append(Historique.utilisateur.contains(v_utilisateur))
            if (v_ipp != ''):
                expr_list.append(Historique.ipp.contains(v_ipp))
            if (v_patient != ''):
                expr_list.append(fn.CONCAT(Patient.nom, " ", Patient.prenom).contains(v_patient))
            if (v_liste != ''):
                expr_list.append(Historique.liste.contains(v_liste))
            if (v_pilulier != ''):
                expr_list.append(Historique.id_pilulier.contains(v_pilulier))
            if (v_fraction != 'Toutes'):
                expr_list.append(Historique.fraction == v_fraction)
            if (v_magasin != 'Tous'):
                expr_list.append(Historique.adresse.contains(v_magasin))
            if (v_service != 'Tous'):
                expr_list.append(Historique.service == v_service)
            if (v_type_mouvement != ''):
                expr_list.append(Historique.type_mouvement << ms)

            andexpr = reduce(operator.and_, expr_list)

            paged_emplacements = (Historique.select(
                Historique.chrono, Historique.reference, Product.designation,
                Historique.fraction, Historique.type_mouvement, Historique.adresse,
                Historique.adresse_from, Historique.quantite_mouvement, Historique.quantite_prescrite,
                Historique.quantite_totale, Historique.info, Historique.quantite_demande,
                Historique.liste, Historique.service, Historique.lot, Historique.ucd,
                Historique.utilisateur, Historique.poste, Historique.date_peremption, Historique.serial,
                Historique.contenant, Patient.nom, Patient.prenom, Historique.id_pilulier)
                .join(Product, JOIN.LEFT_OUTER, on=(Product.reference == Historique.reference))
                .switch(Historique)
                .join(Patient, JOIN.LEFT_OUTER, on=(Patient.ipp == Historique.ipp))
                .where(andexpr)
                .limit(v_limit).offset(v_offset).order_by(v_orderby_column_dir))

            # pdb.set_trace()

            nb = (Historique.select(
                Historique.chrono)
                .join(Product, JOIN.LEFT_OUTER, on=(Product.reference == Historique.reference))
                .switch(Historique)
                .join(Patient, JOIN.LEFT_OUTER, on=(Patient.ipp == Historique.ipp))
                .where(andexpr).count())

            return self.render([{
                'chrono': str(i.chrono),
                'reference': i.reference,
                'designation': (i.product.designation if hasattr(i, 'product') else '(Référence inconnue'),
                'fraction': i.fraction,
                'type_mouvement': self._get_etat_human_label(i.type_mouvement),
                'adresse': i.adresse,
                'adresse_from': i.adresse_from,
                'quantite_mouvement': i.quantite_mouvement,
                'quantite_prescrite': (i.quantite_demande if (i.type_mouvement == 'CPE') or (i.type_mouvement == 'ENT')
                                       else i.quantite_prescrite),
                'quantite_totale': i.quantite_totale,
                'info': i.info,
                'liste': i.liste,
                'service': i.service,
                'patient': (i.patient.nom + " " + i.patient.prenom if hasattr(i, 'patient') else ''),
                'pilulier': i.id_pilulier,
                'lot': i.lot,
                'ucd': i.ucd,
                'utilisateur': i.utilisateur,
                'poste': i.poste,
                'date_peremption': str(i.date_peremption or ''),
                'serial': i.serial,
                'contenant': i.contenant
            } for i in paged_emplacements], v_draw, nb, nb)

        except DoesNotExist:
            logger.error('Get reappro items Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error(('Get reappro items Datatables raised an exception: ', error.args))
            return self.render([], v_draw, 0, 0, error.args)

    def _get_etat_human_label(self, etat_short_label):
        options = {
            'CPE': 'Coupe',
            'DIR': 'Directe',
            'ENT': 'Entrée',
            'SOR': 'Sortie',
            'INV': 'Inventaire',
            'TFT': 'Transfert',
            'REF': 'Référence',
        }
        return options.get(etat_short_label, 'Inconnu')


class ExportHistorique(DataTables):

    def post(self):

        args = parser.parse_args()
        v_orderby = args['orderby']
        v_dir = args['dir']
        v_date_debut = args['date_debut']
        v_date_fin = args['date_fin']
        v_reference = args['reference']
        v_type_mouvement = args['type_mouvement']
        v_fraction = args['fraction']
        v_service = args['service']
        v_magasin = args['magasin']
        v_ucd = args['ucd']
        v_lot = args['lot']
        v_adresse = args['adresse']
        v_serial = args['serial']
        v_contenant = args['contenant']
        v_utilisateur = args['utilisateur']
        v_ipp = args['ipp']
        v_patient = args['patient']
        v_liste = args['liste']
        v_pilulier = args['pilulier']
        v_colvisible = args['colvisible']

        logger.info("Récupérer l'historique")

        if (v_orderby == "0"):
            v_orderby_column = "x_chrono"
        elif (v_orderby == "1"):
            v_orderby_column = "x_ref"
        elif (v_orderby == "2"):
            v_orderby_column = "x_desig"
        elif (v_orderby == "3"):
            v_orderby_column = "x_fraction"
        elif (v_orderby == "4"):
            v_orderby_column = "x_type_mvt"
        elif (v_orderby == "5"):
            v_orderby_column = "x_adr"
        elif (v_orderby == "6"):
            v_orderby_column = "x_adr_from"
        elif (v_orderby == "7"):
            v_orderby_column = "x_qte_mvt"
        elif (v_orderby == "8"):
            v_orderby_column = "x_qte_prescrite"
        elif (v_orderby == "9"):
            v_orderby_column = "x_qte_tot"
        elif (v_orderby == "10"):
            v_orderby_column = "x_info"
        elif (v_orderby == "11"):
            v_orderby_column = "x_liste"
        elif (v_orderby == "12"):
            v_orderby_column = "x_dest"
        elif (v_orderby == "13"):
            v_orderby_column = "x_nom_pat"
        elif (v_orderby == "14"):
            v_orderby_column = "xx_id_pilulier"
        elif (v_orderby == "15"):
            v_orderby_column = "x_lot"
        elif (v_orderby == "16"):
            v_orderby_column = "x_ucd"
        elif (v_orderby == "17"):
            v_orderby_column = "x_user"
        elif (v_orderby == "18"):
            v_orderby_column = "x_poste"
        elif (v_orderby == "19"):
            v_orderby_column = "x_tperemp"
        elif (v_orderby == "20"):
            v_orderby_column = "x_serial"
        elif (v_orderby == "21"):
            v_orderby_column = "x_contenant"
        else:
            v_orderby_column = "x_chrono"

        if (v_dir == 'desc'):
            v_orderby_column_dir = v_orderby_column + " desc"
        else:
            v_orderby_column_dir = v_orderby_column

        if v_type_mouvement:
            ms = v_type_mouvement.split(",")
            ms = "', '".join(ms)

        c_ref = ""
        c_ucd = ""
        c_lot = ""
        c_adr = ""
        c_serial = ""
        c_contenant = ""
        c_user = ""
        c_ipp = ""
        c_patient = ""
        c_liste = ""
        c_pilulier = ""
        c_fraction = ""
        c_mag = ""
        c_dest = ""
        c_type_mvt = ""

        if (v_reference != ''):
            c_ref = " and t1.x_ref=%s" % v_reference
        if (v_ucd != '') and (v_ucd != 'Tous'):
            c_ucd = " and t1.x_ucd like '%%" + v_ucd + "%%'"
        if (v_lot != '') and (v_lot != 'Tous'):
            c_lot = " and t1.x_lot like '%%" + v_lot + "%%'"
        if (v_adresse != ''):
            c_adr = " and t1.x_adr like '%%" + v_adresse + "%%'"
        if (v_serial != ''):
            c_serial = " and t1.x_serial like '%%" + v_serial + "%%'"
        if (v_contenant != ''):
            c_contenant = " and t1.x_ucd like '%%" + v_contenant + "%%'"
        if (v_utilisateur != ''):
            c_user = " and t1.x_user like '%%" + v_utilisateur + "%%'"
        if (v_ipp != ''):
            c_ipp = " and t1.x_num_ipp like '%%" + v_ipp + "%%'"
        if (v_patient != ''):
            c_patient = " and CONCAT(x_nom_pat, ' ', x_prenom_pat) like '%%" + v_patient + "%%'"
        if (v_liste != ''):
            c_liste = " and t1.x_liste like '%%" + v_liste + "%%'"
        if (v_pilulier != ''):
            c_pilulier = " and t1.xx_id_pilulier like '%%" + v_pilulier + "%%'"
        if (v_fraction != 'Toutes'):
            c_fraction = " and t1.x_num_ipp like '%%" + v_fraction + "%%'"
        if (v_magasin != 'Tous'):
            c_mag = " and t1.x_adr like '%%" + v_magasin + "%%'"
        if (v_service != 'Tous'):
            c_dest = " and t1.x_dest ='%s" % v_service
        if (v_type_mouvement != ''):
            c_type_mvt = " and t1.x_type_mvt in('%s')" % ms

        # andexpr = reduce(operator.and_, expr_list)

        # paged_emplacements = (Historique.select(
        #     Historique.chrono, Historique.reference, Product.designation,
        #     Historique.fraction, Historique.type_mouvement, Historique.adresse,
        #     Historique.adresse_from, Historique.quantite_mouvement, Historique.quantite_prescrite,
        #     Historique.quantite_totale, Historique.info,
        #     Historique.liste, Historique.service, Historique.lot, Historique.ucd,
        #     Historique.utilisateur, Historique.poste, Historique.date_peremption, Historique.serial,
        #     Historique.contenant, Patient.nom, Patient.prenom, Historique.id_pilulier)
        #     .join(Product, JOIN.LEFT_OUTER, on=(Product.reference == Historique.reference))
        #     .switch(Historique)
        #     .join(Patient, JOIN.LEFT_OUTER, on=(Patient.ipp == Historique.ipp))
        #     .where(andexpr)
        #     .order_by(v_orderby_column_dir))

        # logger.info(paged_emplacements.sql())
        query = """
                SELECT `t1`.`x_chrono`, `t1`.`x_ref`, `t2`.`x_desig`, `t1`.`x_fraction`, `t1`.`x_type_mvt`,
                `t1`.`x_adr`,
                `t1`.`x_adr_from`, `t1`.`x_qte_mvt`, `t1`.`x_qte_prescrite`, `t1`.`x_qte_tot`, `t1`.`x_info`,
                `t1`.`x_liste`, `t1`.`x_dest`, `t1`.`x_lot`, `t1`.`x_ucd`, `t1`.`x_user`, `t1`.`x_poste`,
                `t1`.`x_tperemp`, `t1`.`x_serial`, `t1`.`x_contenant`,
                if(isnull(`t3`.`x_nom_pat`),'',concat(x_nom_pat, ' ', x_prenom_pat)) as x_nom_pat,
                `t1`.`xx_id_pilulier` FROM `f_histo` AS `t1` LEFT OUTER JOIN `f_ref` AS `t2`
                ON (`t2`.`x_ref` = `t1`.`x_ref`) LEFT OUTER JOIN `f_patient` AS `t3`
                ON (`t3`.`x_num_ipp` = `t1`.`x_num_ipp`)
                WHERE x_chrono>= '{0}' and x_chrono<=
                  '{1}'{2}{3}{4}{5}{6}{7}{8}{9}{10}{11}{12}{13}{14}{15}{16}
                 ORDER BY {17}
            """.format(
                v_date_debut, v_date_fin, c_ref, c_ucd, c_lot, c_adr, c_serial, c_contenant, c_user, c_ipp,
                c_patient, c_liste, c_pilulier, c_fraction, c_mag, c_dest, c_type_mvt, v_orderby_column_dir)
        # cr = mysql_db.execute_sql(query)

        MYSQL_DB_HOST = os.environ.get('MEDIAN_DB_HOST', 'localhost')
        MYSQL_DB_NAME = os.environ.get('MEDIAN_DB_NAME', 'median')
        logger.info(MYSQL_DB_HOST)
        logger.info(MYSQL_DB_NAME)
        engine = create_engine("mysql://root:root@%s/%s" % (MYSQL_DB_HOST, MYSQL_DB_NAME), echo=True)
        conn = engine.connect()

        # result = conn.execute(query)
        proxy = conn.execution_options(stream_results=True).execute(query)

        try:
            # datadump = BytesIO()
            i = 0
            ms = v_colvisible.split(",")

            name = uuid.uuid4()
            Path("tmp_export").mkdir(parents=True, exist_ok=True)
            writer = xlsxwriter.Workbook(os.sep.join(
                [os.getcwd(), "tmp_export", "%s.xlsx" % name]), {'constant_memory': True})
            logger.info(os.sep.join([os.getcwd(), "tmp_export", "%s.xlsx" % name]))
            # writer = MyWorkbook(writer)
            format = writer.add_format({'num_format': 'dd/mm/yyyy hh:mm:ss'})
            format_court = writer.add_format({'num_format': 'dd/mm/yyyy'})

            worksheet = writer.add_worksheet("Feuille1")
            worksheet.max_column_widths = {}

            j = 0
            if ms[0] == "true":
                worksheet.max_column_widths[j] = 18
                worksheet.write(0, j, "Date")
                j += 1
            if ms[1] == "true":
                worksheet.max_column_widths[j] = 10
                worksheet.write_string(0, j, "Référence")
                j += 1
            if ms[2] == "true":
                worksheet.write_string(0, j, "Désignation")
                j += 1
            if ms[3] == "true":
                worksheet.write_string(0, j, "Fraction")
                j += 1
            if ms[4] == "true":
                worksheet.max_column_widths[j] = 10
                worksheet.write_string(0, j, "Type mvt")
                j += 1
            if ms[5] == "true":
                worksheet.write_string(0, j, "Emplacement")
                j += 1
            if ms[6] == "true":
                worksheet.write_string(0, j, "Départ")
                j += 1
            if ms[7] == "true":
                worksheet.write_string(0, j, "Qté mvt")
                j += 1
            if ms[8] == "true":
                worksheet.write_string(0, j, "Qté dem")
                j += 1
            if ms[9] == "true":
                worksheet.write_string(0, j, "Qté totale")
                j += 1
            if ms[10] == "true":
                worksheet.write_string(0, j, "Info")
                j += 1
            if ms[11] == "true":
                worksheet.write_string(0, j, "Liste")
                j += 1
            if ms[12] == "true":
                worksheet.max_column_widths[j] = 8
                worksheet.write_string(0, j, "Service")
                j += 1
            if ms[13] == "true":
                worksheet.write_string(0, j, "Patient")
                j += 1
            if ms[14] == "true":
                worksheet.write_string(0, j, "N° pilulier")
                j += 1
            if ms[15] == "true":
                worksheet.write_string(0, j, "N° de lot")
                j += 1
            if ms[16] == "true":
                worksheet.write_string(0, j, "UCD")
                j += 1
            if ms[17] == "true":
                worksheet.write_string(0, j, "Utilisateur")
                j += 1
            if ms[18] == "true":
                worksheet.write_string(0, j, "Poste")
                j += 1
            if ms[19] == "true":
                worksheet.max_column_widths[j] = 11
                worksheet.write_string(0, j, "Péremption")
                worksheet.set_column(j, j, 18)
                j += 1
            if ms[20] == "true":
                worksheet.write_string(0, j, "N° de série")
                j += 1
            if ms[21] == "true":
                worksheet.write_string(0, j, "Contenant")
                j += 1

            while 'batch not empty':  # equivalent of 'while True', but clearer
                batch = proxy.fetchmany(10000)  # 100,000 rows at a time

                if not batch:
                    break

                for row in batch:
                    # logger.info(row["x_chrono"])
                    # # df = pd.DataFrame(list(paged_emplacements.dicts()))
                    # # for row in paged_emplacements.iterator():
                    i += 1
                    j = 0
                    if ms[0] == "true":
                        worksheet.write_datetime(i, j, row["x_chrono"], format)
                        j += 1
                    if ms[1] == "true":
                        excel_string_width(row["x_ref"], j, worksheet)
                        worksheet.write_string(i, j, row["x_ref"])
                        j += 1
                    if ms[2] == "true":
                        excel_string_width((row["x_desig"] or 'Référence inconnue'), j, worksheet)
                        worksheet.write_string(i, j, (row["x_desig"] or 'Référence inconnue'))
                        j += 1
                    if ms[3] == "true":
                        worksheet.write(i, j, row["x_fraction"])
                        j += 1
                    if ms[4] == "true":
                        excel_string_width(row["x_type_mvt"], j, worksheet)
                        worksheet.write_string(i, j, self._get_etat_human_label(row["x_type_mvt"]))
                        j += 1
                    if ms[5] == "true":
                        excel_string_width(row["x_adr"], j, worksheet)
                        worksheet.write_string(i, j, row["x_adr"])
                        j += 1
                    if ms[6] == "true":
                        excel_string_width(row["x_adr_from"], j, worksheet)
                        worksheet.write_string(i, j, row["x_adr_from"])
                        j += 1
                    if ms[7] == "true":
                        worksheet.write(i, j, row["x_qte_mvt"])
                        j += 1
                    if ms[8] == "true":
                        worksheet.write(i, j, row["x_qte_prescrite"])
                        j += 1
                    if ms[9] == "true":
                        worksheet.write(i, j, row["x_qte_tot"])
                        j += 1
                    if ms[10] == "true":
                        excel_string_width(row["x_info"], j, worksheet)
                        worksheet.write_string(i, j, row["x_info"])
                        j += 1
                    if ms[11] == "true":
                        excel_string_width(row["x_liste"], j, worksheet)
                        worksheet.write_string(i, j, row["x_liste"])
                        j += 1
                    if ms[12] == "true":
                        excel_string_width(row["x_dest"], j, worksheet)
                        worksheet.write_string(i, j, row["x_dest"])
                        j += 1
                    if ms[13] == "true":
                        excel_string_width(row["x_nom_pat"], j, worksheet)
                        worksheet.write_string(i, j, row["x_nom_pat"])
                        j += 1
                    if ms[14] == "true":
                        excel_string_width(row["xx_id_pilulier"], j, worksheet)
                        worksheet.write_string(i, j, row["xx_id_pilulier"])
                        j += 1
                    if ms[15] == "true":
                        excel_string_width(row["x_lot"], j, worksheet)
                        worksheet.write_string(i, j, row["x_lot"])
                        j += 1
                    if ms[16] == "true":
                        excel_string_width(row["x_ucd"], j, worksheet)
                        worksheet.write_string(i, j, row["x_ucd"])
                        j += 1
                    if ms[17] == "true":
                        excel_string_width(row["x_user"], j, worksheet)
                        worksheet.write_string(i, j, row["x_user"])
                        j += 1
                    if ms[18] == "true":
                        excel_string_width(row["x_poste"], j, worksheet)
                        worksheet.write_string(i, j, row["x_poste"])
                        j += 1
                    if ms[19] == "true":
                        if row["x_tperemp"]:
                            worksheet.write_datetime(i, j, row["x_tperemp"], format_court)
                        j += 1
                    if ms[20] == "true":
                        excel_string_width(row["x_serial"], j, worksheet)
                        worksheet.write_string(i, j, row["x_serial"])
                        j += 1
                    if ms[21] == "true":
                        excel_string_width(row["x_contenant"], j, worksheet)
                        worksheet.write_string(i, j, row["x_contenant"])
                        j += 1

            for column, width in worksheet.max_column_widths.items():
                worksheet.set_column(column, column, width)

            writer.close()
            proxy.close()

            # response = make_response(datadump.getvalue())
            # response.mimetype = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
            # response.headers.set('Content-Disposition', 'attachment', filename='test.xlsx')
            # logger.info("ok")
            # return response

            logger.info([os.getcwd(), "tmp_export", "%s.xlsx" % name])
            return send_file(os.sep.join(
                [os.getcwd(), "tmp_export", "%s.xlsx" % name]),
                as_attachment=True, attachment_filename='download_filename.xlsx')

        except Exception as error:
            logger.error('Datatables Historique raised an exception: ', error.args)

    def _get_etat_human_label(self, etat_short_label):
        options = {
            'CPE': 'Coupe',
            'DIR': 'Directe',
            'ENT': 'Entrée',
            'SOR': 'Sortie',
            'INV': 'Inventaire',
            'TFT': 'Transfert',
            'REF': 'Référence',
        }
        return options.get(etat_short_label, 'Inconnu')


def excel_string_width(str, j, worksheet):
    """
    Calculate the length of the string in Excel character units. This is only
    an example and won't give accurate results. It will need to be replaced
    by something more rigorous.

    """

    min_width = 0

    # Check if it the string is the largest we have seen for this column.

    string_width = len(str)

    if string_width > min_width:
        max_width = worksheet.max_column_widths.get(j, min_width)
        if string_width > max_width:
            worksheet.max_column_widths[j] = string_width * 1.1
