from flask_restful import reqparse
from common.rest import DataTables
# from flask import session
# from median.models import FListe
from peewee import DoesNotExist
from common.util import logger
from median.models import Emplacements
from median.models import Stock, Adresse

parser = reqparse.RequestParser()
parser.add_argument('draw', type=int, help='Draw parameter for Datatables')
parser.add_argument('start', type=int, help='Pagination starts')
parser.add_argument('length', type=int, help='Pagination length')
parser.add_argument('order[0][column]', type=int, help='Ord parameter for DT')
parser.add_argument('order[0][dir]', help='Ord parameter for Datatables')
parser.add_argument("filterByMagasin")
parser.add_argument('adr')
parser.add_argument('bloque', type=str)
parser.add_argument('etat')
parser.add_argument('format')
parser.add_argument('fonction')
parser.add_argument('date_peremption')


class DataTableEmplacements(DataTables):

    def post(self):

        args = parser.parse_args()
        v_draw = args['draw']
        v_orderby = args['order[0][column]']
        v_dir = args['order[0][dir]']
        v_filter_by_magasin = args['filterByMagasin']
        v_start = args['start']
        v_length = args['length']
        v_format = args['format']
        v_bloque = args['bloque']
        v_fonction = args['fonction']
        v_date_peremption = args['date_peremption']

        logger.info("Récupérer les emplacements")

        try:

            if (v_orderby == 1):
                v_orderby_column = Emplacements.bloque
            elif (v_orderby == 2):
                v_orderby_column = Emplacements.libelle
            elif (v_orderby == 3):
                v_orderby_column = Emplacements.adr
            elif (v_orderby == 4):
                v_orderby_column = Emplacements.x_format
            elif (v_orderby == 5):
                v_orderby_column = Emplacements.contenant
            elif (v_orderby == 6):
                v_orderby_column = Emplacements.etat
            elif (v_orderby == 7):
                v_orderby_column = Emplacements.qte
            elif (v_orderby == 8):
                v_orderby_column = Emplacements.fraction
            elif (v_orderby == 9):
                v_orderby_column = Emplacements.ref
            elif (v_orderby == 10):
                v_orderby_column = Emplacements.designation
            elif (v_orderby == 11):
                v_orderby_column = Emplacements.ucd
            elif (v_orderby == 12):
                v_orderby_column = Emplacements.sortie
            elif (v_orderby == 13):
                v_orderby_column = Emplacements.entree
            elif (v_orderby == 14):
                v_orderby_column = Emplacements.lot
            elif (v_orderby == 15):
                v_orderby_column = Emplacements.peremp
            else:
                v_orderby_column = Emplacements.adr

            if (v_dir == 'desc'):
                v_orderby_column_dir = v_orderby_column.desc()
            else:
                v_orderby_column_dir = v_orderby_column

            ms = v_filter_by_magasin.split(",")
            mf = []

            if not v_format:
                format = Adresse.select(Adresse.format).distinct()
                for f in format:
                    mf.append(f.format)
            else:
                mf = v_format.split(",")

            if not v_date_peremption:
                dp = "9999-12-31"
            else:
                dp = v_date_peremption

            if not v_filter_by_magasin:
                if (v_fonction == '2'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree,
                            Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.bloque >= v_bloque) & (Emplacements.x_format << mf) & (
                            Emplacements.etat == 'Vide')))
                elif (v_fonction == '3'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format, Emplacements.bloque, Emplacements.ref, Emplacements.qte,
                            Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.bloque >= v_bloque) & (Emplacements.x_format << mf) & (
                            Emplacements.etat == 'Avec produits')))
                elif (v_fonction == '4'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.bloque >= v_bloque) & (Emplacements.x_format << mf) & (
                            Emplacements.contenant == '')))
                elif (v_fonction == '5'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.bloque >= v_bloque) & (Emplacements.x_format << mf) & (
                            Emplacements.contenant != '')))
                elif (v_fonction == '6'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.taquin == 2)))
                elif (v_fonction == '7'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.demi_taquin == 2)))
                else:

                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.bloque >= v_bloque) & (Emplacements.x_format << mf) & (
                            Emplacements.peremp <= dp)))

            else:
                if (v_fonction == '2'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.bloque >= v_bloque) & (
                            Emplacements.x_format << mf) & (Emplacements.etat == 'Vide')))
                elif (v_fonction == '3'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.bloque >= v_bloque) & (
                            Emplacements.x_format << mf) & (Emplacements.etat == 'Avec produits')))
                elif (v_fonction == '4'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.bloque >= v_bloque) & (
                            Emplacements.x_format << mf) & (Emplacements.contenant == '')))
                elif (v_fonction == '5'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.bloque >= v_bloque) & (
                            Emplacements.x_format << mf) & (Emplacements.contenant != '')))
                elif (v_fonction == '6'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.taquin == 2)))
                elif (v_fonction == '7'):
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.demi_taquin == 2)))
                else:
                    total_stocks_count = (
                        Emplacements.select(
                            Emplacements.pk, Emplacements.adr, Emplacements.etat, Emplacements.libelle,
                            Emplacements.x_format,
                            Emplacements.bloque, Emplacements.ref, Emplacements.qte, Emplacements.contenant,
                            Emplacements.fraction, Emplacements.designation, Emplacements.ucd, Emplacements.sortie,
                            Emplacements.entree, Emplacements.lot, Emplacements.peremp
                        ).where((Emplacements.magasin << ms) & (Emplacements.bloque >= v_bloque) & (
                            Emplacements.x_format << mf) & (Emplacements.peremp <= dp)))

            filtered_products = total_stocks_count.order_by(v_orderby_column_dir)

            paged_emplacements = filtered_products.limit(v_length).offset(v_start)

            return self.render([{
                'pk': i.pk,
                'adr': i.adr,
                'format': i.x_format,
                'bloque': i.bloque,
                'libelle': i.libelle,
                'etat': i.etat,
                'contenant': i.contenant,
                'reference': i.ref,
                'quantite': i.qte,
                'fraction': i.fraction,
                'designation': i.designation,
                'ucd': i.ucd,
                'sortie': str(i.sortie or ''),
                'entree': str(i.entree or ''),
                'lot': i.lot,
                'peremp': str(i.peremp or '')
            } for i in paged_emplacements], v_draw, total_stocks_count.count(), filtered_products.count())

        except DoesNotExist:
            logger.error('Get reappro items Datatables raised a DoesNotExist exception')
            return self.render([], v_draw, 0, 0)
        except Exception as error:
            logger.error(('Get reappro items Datatables raised an exception: ', error.args))
            return self.render([], v_draw, 0, 0, error.args)

    def put(self):

        args = parser.parse_args()
        adr = args['adr']
        bloque = args['bloque']
        etat = args['etat']

        logger.info('Blocage/Déblocage adresse: "%s"' % (adr))

        if not adr:
            logger.warning('Adresse manquante!')
            return 'Adresse manquante!'

        try:
            n = (Stock
                 .update({Stock.bloque: bloque})
                 .where(Stock.adresse == adr))
            n.execute()

            if (bloque == '0'):
                if (etat == 'Avec produits'):
                    etat = 'O'
                else:
                    etat = 'L'

            if (bloque == '0'):
                Adresse_bloque = 0
            else:
                Adresse_bloque = 1

            n = (Adresse
                 .update({Adresse.etat: etat, Adresse.bloque: Adresse_bloque})
                 .where(Adresse.adresse == adr))
            n.execute()

        except DoesNotExist:
            logger.error('Ce produit n\'existe pas! Réf: "%s"' % (adr))
            return {'message': 'Product does not exist'}, 404
        except Exception as error:
            logger.error(error.args)
            return {'message': error.args}, 503

        logger.info('L\'adresse a été modifié sans problème. Réf: "%s"' % (adr))
        return 'Success'
