# flake8: noqa

# Import all datatables in this file and use it on app.py like:
#

from .stock import DatatableStock
from .liste_reappro_items import DataTableListeReapproItems
from .liste_sorties_items import DataTableListeSortiesItems
from .liste_sorties_listes import DataTableListeSortiesListes
from .riedl_entrees_items import DataTableRiedlEntreesItems
from .riedl_sorties_items import DataTableRiedlSortiesItems
from .emplacements import DataTableEmplacements
from .historique import DataTableHistorique, ExportHistorique
from .stocks import DatatableStocks
from .users import DataTableUsers
from .suivi_production import DataTableCadencePilulierParService, DataTableCadenceCarnetParService
from .services import DataTableServices
from .seuils import DatatableSeuils

def add_dt_route(api_handle):
    """Add dynamically datatableo route"""
    api_handle.add_resource(DatatableStock, '/datatable/stock/<string:ref>')
    api_handle.add_resource(DataTableListeReapproItems, '/datatable/liste_reappro_items/<string:pk_liste>')
    api_handle.add_resource(DataTableListeSortiesItems, '/datatable/liste_sorties_items/<string:pk_liste>')
    api_handle.add_resource(DataTableListeSortiesListes, '/datatable/liste_sorties_listes/<string:service>')
    api_handle.add_resource(DatatableStocks, '/datatable/stocks/<string:ref>')
    api_handle.add_resource(DataTableEmplacements, '/datatable/emplacements')
    api_handle.add_resource(DataTableHistorique, '/datatable/historique')
    api_handle.add_resource(ExportHistorique, '/datatable/export_historique')
    api_handle.add_resource(DataTableUsers, '/datatable/users')
    api_handle.add_resource(DataTableServices, '/datatable/services')
    # api_handle.add_resource(DataTableSuiviProd, '/datatable/suivi_production')
    # Datatable pour Riedl
    api_handle.add_resource(DataTableRiedlEntreesItems, '/datatable/riedl_entrees_items/<string:x_liste>')
    api_handle.add_resource(DataTableRiedlSortiesItems, '/datatable/riedl_sorties_items/<string:x_liste>')
    # Dashboard
    api_handle.add_resource(DataTableCadencePilulierParService, '/datatable/cadence_pilulier_par_service')
    api_handle.add_resource(DataTableCadenceCarnetParService, '/datatable/cadence_carnet_par_service')
    api_handle.add_resource(DatatableSeuils, '/datatable/seuils/<string:ref>')
