from flask_restful import Resource, reqparse
from median.models import Historique, SuiviProd, SuiviProdMinutes, Magasin
from peewee import fn
from datetime import datetime, timedelta
import logging
import xlsxwriter
from flask import send_file
import os
import uuid
from pathlib import Path

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument("date_debut_export")
parser.add_argument("date_fin_export")
parser.add_argument("date_debut")
parser.add_argument("date_fin")
parser.add_argument("date")
parser.add_argument("mag")
parser.add_argument("affichage")


class ApiDashboard_Coupe(Resource):

    def get(self):

        args = parser.parse_args()
        v_date_debut = args['date_debut']
        v_date_fin = args['date_fin']
        v_affichage = args['affichage']

        # date = datetime.strptime(v_date_fin, "%Y-%m-%d")
        # v_date_fin = date + timedelta(days=1)

        labels = []
        data = []

        l_seuil = []

        if (v_affichage == "1"):
            l_seuil = (
                Historique.select(fn.substr(Historique.chrono, 1, 10).alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & ((Historique.type_mouvement == 'CPE') | (Historique.type_mouvement == 'DIR'))).group_by(
                        fn.Substr(Historique.chrono, 1, 10)))

        if (v_affichage == "2"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y-%V').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & ((Historique.type_mouvement == 'CPE') | (Historique.type_mouvement == 'DIR'))).group_by(
                        fn.date_format(Historique.chrono, '%Y-%V')))

        if (v_affichage == "3"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y-%m').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & ((Historique.type_mouvement == 'CPE') | (Historique.type_mouvement == 'DIR'))).group_by(
                        fn.date_format(Historique.chrono, '%Y-%m')))

        if (v_affichage == "4"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & ((Historique.type_mouvement == 'CPE') | (Historique.type_mouvement == 'DIR'))).group_by(
                        fn.date_format(Historique.chrono, '%Y')))

        # query = """
        #         SELECT date(x_chrono) as x_chrono, sum(x_qte_mvt) as x_qte_mvt
        #           FROM f_histo where date(x_chrono)>='20210112'
        #           and x_type_mvt='CPE'
        #           GROUP BY date(x_chrono)
        #     """
        # cr = mysql_db.execute_sql(query)

        # pdb.set_trace()

        for ls in l_seuil:
            if (v_affichage == "1"):
                labels.append(str(ls.x_chrono)[8:10]+"/"+str(ls.x_chrono)[5:7]+"/"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "2"):
                labels.append("S"+str(ls.x_chrono)[5:7]+"-"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "3"):
                labels.append(""+str(ls.x_chrono)[5:7]+"-"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "4"):
                labels.append(""+str(ls.x_chrono)[0:4])
            data.append(ls.x_qte_mvt)

        data = {
            'labels': labels,
            'data': data
        }
        return data


class ApiDashboard_Cueillette(Resource):

    def get(self):

        args = parser.parse_args()
        v_date_debut = args['date_debut']
        v_date_fin = args['date_fin']
        v_affichage = args['affichage']

        date = datetime.strptime(v_date_fin, "%Y-%m-%d")
        v_date_fin = date + timedelta(days=1)

        labels = []
        data = []

        l_seuil = []

        if (v_affichage == "1"):
            l_seuil = (Historique.select(fn.substr(Historique.chrono, 1, 10).alias('x_chrono'), fn.SUM(
                Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'SOR')).group_by(
                    fn.Substr(Historique.chrono, 1, 10)))

        if (v_affichage == "2"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y-%V').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'SOR')).group_by(
                        fn.date_format(Historique.chrono, '%Y-%V')))

        if (v_affichage == "3"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y-%m').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'SOR')).group_by(
                        fn.date_format(Historique.chrono, '%Y-%m')))

        if (v_affichage == "4"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'SOR')).group_by(
                        fn.date_format(Historique.chrono, '%Y')))

        # query = """
        #         SELECT date(x_chrono) as x_chrono, sum(x_qte_mvt) as x_qte_mvt
        #           FROM f_histo where date(x_chrono)>='20210112'
        #           and x_type_mvt='CPE'
        #           GROUP BY date(x_chrono)
        #     """
        # cr = mysql_db.execute_sql(query)

        # pdb.set_trace()

        for ls in l_seuil:
            if (v_affichage == "1"):
                labels.append(str(ls.x_chrono)[8:10]+"/"+str(ls.x_chrono)[5:7]+"/"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "2"):
                labels.append("S"+str(ls.x_chrono)[5:7]+"-"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "3"):
                labels.append(""+str(ls.x_chrono)[5:7]+"-"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "4"):
                labels.append(""+str(ls.x_chrono)[0:4])
            data.append(ls.x_qte_mvt)

        data = {
            'labels': labels,
            'data': data
        }
        return data


class ApiDashboard_Retour(Resource):

    def get(self):

        args = parser.parse_args()
        v_date_debut = args['date_debut']
        v_date_fin = args['date_fin']
        v_affichage = args['affichage']

        date = datetime.strptime(v_date_fin, "%Y-%m-%d")
        v_date_fin = date + timedelta(days=1)

        labels = []
        data = []

        l_seuil = []

        if (v_affichage == "1"):
            l_seuil = (Historique.select(fn.substr(Historique.chrono, 1, 10).alias('x_chrono'), fn.SUM(
                Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'ENT') & (Historique.service != '')).group_by(
                        fn.Substr(Historique.chrono, 1, 10)))

        if (v_affichage == "2"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y-%V').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'SOR')).group_by(
                        fn.date_format(Historique.ENT, '%Y-%V')))

        if (v_affichage == "3"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y-%m').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'ENT')).group_by(
                        fn.date_format(Historique.chrono, '%Y-%m')))

        if (v_affichage == "4"):
            l_seuil = (
                Historique.select(fn.date_format(Historique.chrono, '%Y').alias('x_chrono'), fn.SUM(
                    Historique.quantite_mouvement).alias("x_qte_mvt")).where(
                    (Historique.chrono >= v_date_debut) & (Historique.chrono <= v_date_fin)
                    & (Historique.type_mouvement == 'ENT')).group_by(
                        fn.date_format(Historique.chrono, '%Y')))

        # query = """
        #         SELECT date(x_chrono) as x_chrono, sum(x_qte_mvt) as x_qte_mvt
        #           FROM f_histo where date(x_chrono)>='20210112'
        #           and x_type_mvt='CPE'
        #           GROUP BY date(x_chrono)
        #     """
        # cr = mysql_db.execute_sql(query)

        # pdb.set_trace()

        for ls in l_seuil:
            if (v_affichage == "1"):
                labels.append(str(ls.x_chrono)[8:10]+"/"+str(ls.x_chrono)[5:7]+"/"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "2"):
                labels.append("S"+str(ls.x_chrono)[5:7]+"-"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "3"):
                labels.append(""+str(ls.x_chrono)[5:7]+"-"+str(ls.x_chrono)[0:4])
            elif (v_affichage == "4"):
                labels.append(""+str(ls.x_chrono)[0:4])
            data.append(ls.x_qte_mvt)

        data = {
            'labels': labels,
            'data': data
        }
        return data


class ApiDashboard_Cueillette_v3(Resource):

    def post(self):

        args = parser.parse_args()
        v_date = args['date']
        v_mag = args['mag']

        # date = datetime.strptime(v_date_fin, "%Y-%m-%d")
        # v_date_fin = date + timedelta(days=1)

        labels = []
        data = []

        date_fin = datetime.strptime(v_date, "%Y-%m-%d") + timedelta(days=1)

        l_date = []

        l_date = (SuiviProd.select(fn.MIN(SuiviProd.chrono).alias('x_min'), fn.MAX(
                SuiviProd.chrono).alias('x_max')).where(
                (SuiviProd.chrono >= v_date) & (SuiviProd.chrono < date_fin)
                & (SuiviProd.poste == v_mag) &
                ((SuiviProd.variable == 'API_Nbr_Produit_Pilulier_Med') |
                    (SuiviProd.variable == 'API_Nbr_de_Produit_Carnet_Med'))))

        for ld in l_date:
            x_min = ld.x_min
            x_max = ld.x_max

        # def daterange(date1, date2):
        #     for n in range(int ((date2 - date1).seconds)+1):
        #         yield date1 + timedelta(n)

        # for dt in daterange(x_min, x_max):
            # logger.info(dt.strftime("%H-%M-%S"))

        # logger.info(seconds)

        # for i in range(0, int(seconds)):
        #     added_seconds = timedelta(0, int(i))
        #     new_datetime = x_min + added_seconds
        #     logger.info(new_datetime.strftime("%H-%M-%S"))

        # l_seuil = (
        #     SuiviProd.select(fn.substr(SuiviProd.chrono, 12, 8).alias('x_chrono'),
        #         SuiviProd.valeur_num.alias("x_qte_mvt"), SuiviProd.variable.alias('x_variable')).where(
        #         (SuiviProd.chrono >= v_date) & (SuiviProd.chrono < date_fin)
        #         & (SuiviProd.poste == v_mag) &
        #         (SuiviProd.variable == 'API_Nbr_Produit_Pilulier_Med')))

        # l_seuil = (
        #     SuiviProd.select(SuiviProd.chrono.alias('x_chrono'),
        #         SuiviProd.valeur_num.alias("x_qte_mvt"), SuiviProd.variable.alias('x_variable')).where(
        #         (SuiviProd.chrono >= v_date) & (SuiviProd.chrono < date_fin)
        #         & (SuiviProd.poste == v_mag) &
        #         (SuiviProd.variable == 'API_Nbr_Produit_Pilulier_Med') |
        #         (SuiviProd.variable == 'API_Nbr_de_Produit_Carnet_Med')))

        l_seuil = (
            SuiviProd.select(
                SuiviProd.chrono.alias('x_chrono'),
                SuiviProd.valeur_num.alias("x_qte_mvt"), SuiviProd.variable.alias('x_variable')).where(
                (SuiviProd.chrono >= v_date) & (SuiviProd.chrono < date_fin)
                & (SuiviProd.poste == v_mag) &
                ((SuiviProd.variable == 'API_Nbr_Produit_Pilulier_Med') |
                    (SuiviProd.variable == 'API_Nbr_de_Produit_Carnet_Med'))))

        labels1 = []

        data1 = []
        data2 = []
        data3 = []
        data4 = []

        l_seuil1 = (
            SuiviProd.select(
                SuiviProd.chrono.alias('x_chrono'),
                SuiviProd.valeur_num.alias("x_qte_mvt"), SuiviProd.variable.alias('x_variable')).where(
                (SuiviProd.chrono >= v_date) & (SuiviProd.chrono < date_fin)
                & (SuiviProd.poste == v_mag) &
                ((SuiviProd.variable == 'API_Nbr_de_Pilulier_Med') |
                    (SuiviProd.variable == 'API_Nbr_Carnet_Pilulier_Med'))))

        x_min = str(x_min)[11:19]
        x_max = str(x_max)[11:19]

        l_seuil4 = (SuiviProdMinutes.select(
            SuiviProdMinutes.chrono.alias('x_chrono'),
            SuiviProdMinutes.valeur_num.alias("x_qte_mvt"), SuiviProdMinutes.variable.alias('x_variable')).where(
            (fn.TIME(SuiviProdMinutes.chrono) >= x_min) & (fn.TIME(SuiviProdMinutes.chrono) <= x_max)))

        l_seuil2 = (l_seuil | l_seuil1 | l_seuil4).order_by('x_chrono')
        l_seuil3 = l_seuil2.order_by(fn.TIME(l_seuil2.c.x_chrono))

        # for i in range(0, int(seconds)):
        #     added_seconds = timedelta(0, int(i))
        #     new_datetime = x_min + added_seconds
        #     labels.append(str(new_datetime))
        #     logger.info(new_datetime.strftime("%H-%M-%S"))
        #     data.append(None)

        # last_API_Nbr_Produit_Pilulier_Med = 0
        # last_API_Nbr_de_Produit_Carnet_Med = 0

        # last_API_Nbr_de_Pilulier_Med = 0
        # last_API_Nbr_Carnet_Pilulier_Med = 0

        for ls in l_seuil3:

            # time = datetime.strptime(ls.x_chrono,'%Y-%m-%d %H%M%S')
            # now = datetime.datetime.now()

            # logger.info(ls.x_chrono.hour)
            if (ls.x_variable == 'API_Nbr_de_Pilulier_Med'):
                labels1.append(str(ls.x_chrono)[11:19])
                labels.append(str(ls.x_chrono)[11:19])
                data1.append(ls.x_qte_mvt)
                data3.append(None)
                data2.append(None)
                data4.append(None)

                # last_API_Nbr_de_Pilulier_Med = ls.x_qte_mvt

            elif (ls.x_variable == 'API_Nbr_Carnet_Pilulier_Med'):
                labels1.append(str(ls.x_chrono)[11:19])
                labels.append(str(ls.x_chrono)[11:19])
                data4.append(ls.x_qte_mvt)
                data1.append(None)
                data2.append(None)
                data3.append(None)

                # last_API_Nbr_Carnet_Pilulier_Med = ls.x_qte_mvt

            elif (ls.x_variable == 'API_Nbr_Produit_Pilulier_Med'):
                labels1.append(str(ls.x_chrono)[11:19])
                labels.append(str(ls.x_chrono)[11:19])
                data3.append(ls.x_qte_mvt)
                data1.append(None)
                data2.append(None)
                data4.append(None)

                # if (last_API_Nbr_Produit_Pilulier_Med < ls.x_qte_mvt):
                #     last_API_Nbr_Produit_Pilulier_Med = ls.x_qte_mvt

            elif (ls.x_variable == 'API_Nbr_de_Produit_Carnet_Med'):
                labels1.append(str(ls.x_chrono)[11:19])
                labels.append(str(ls.x_chrono)[11:19])
                data2.append(ls.x_qte_mvt)
                data1.append(None)
                data3.append(None)
                data4.append(None)

                # if (last_API_Nbr_de_Produit_Carnet_Med < ls.x_qte_mvt):
                #     last_API_Nbr_de_Produit_Carnet_Med = ls.x_qte_mvt
            else:
                labels.append(str(ls.x_chrono)[11:19])
                # data.append(ls.x_qte_mvt)
                data1.append(None)
                data2.append(None)
                data.append(None)
                data3.append(None)
                data4.append(None)

        # for ls in l_seuil1:
        #     labels1.append(ls.x_chrono)
        #     data1.append(ls.x_qte_mvt)
        #     labels.append(ls.x_chrono)
        #     data.append('')

        data = {
            'labels': labels,
            'data': data,
            'labels1': labels1,
            'data1': data1,
            'data2': data2,
            'data3': data3,
            'data4': data4,
        }
        return data


class ApiExportCompteurs(Resource):

    def post(self):

        args = parser.parse_args()
        v_date_debut = args['date_debut_export']
        v_date_fin = args['date_fin_export']

        # Compteur = SuiviProd.select().where(
        #             (SuiviProd.chrono >= v_date_debut) & (SuiviProd.chrono <= v_date_fin))

        # logger.info('Export compteurs 1: ' + str(len(Compteur)))

        try:

            name = uuid.uuid4()
            Path("tmp_export").mkdir(parents=True, exist_ok=True)
            writer = xlsxwriter.Workbook(os.sep.join(
                [os.getcwd(), "tmp_export", "%s.xlsx" % name]), {'constant_memory': True})
            logger.info(os.sep.join([os.getcwd(), "tmp_export", "%s.xlsx" % name]))
            # writer = MyWorkbook(writer)
            # format = writer.add_format({'num_format': 'dd/mm/yyyy hh:mm:ss'})
            format_court = writer.add_format({'num_format': 'dd/mm/yyyy'})

            mags = (Magasin
                    .select(
                        Magasin.type_mag,
                        Magasin.type_machine).where(
                            Magasin.type_machine == 'ACCED_V3').order_by(Magasin.type_mag))

            for row in mags:
                if row.type_machine == "ACCED_V3":

                    worksheet = writer.add_worksheet(row.type_mag)
                    worksheet.max_column_widths = {}

                    i = 0

                    j = 0

                    worksheet.max_column_widths[j] = 14
                    worksheet.write(0, j, "Date")
                    j += 1

                    worksheet.max_column_widths[j] = 10
                    worksheet.write_string(0, j, "Nb piluliers", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb plateaux", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Doses unitaires tiroirs", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.max_column_widths[j] = 10
                    worksheet.write_string(0, j, "Sachet boite PASS", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Sachets poudres", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Tickets", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps cueillette", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb doses/pilulier", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Cadence", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.max_column_widths[j] = 10
                    worksheet.write_string(0, j, "Nb carnets", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb plateaux", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb piluliers", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Doses unitaires tiroirs", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.max_column_widths[j] = 10
                    worksheet.write_string(0, j, "Sachet boite PASS", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Sachets poudres", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Tickets", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps cueillette", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb doses/pilulier", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Cadence", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Blisters chargés", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Goulotte chargés", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.max_column_widths[j] = 8
                    worksheet.write_string(0, j, "Blister pris", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Goulotte en erreurs", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb doses rangées", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Nb doses rangées/heure", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps de chargement", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps déchargement plateau", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps avant intervention panne",
                                           writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.max_column_widths[j] = 11
                    worksheet.write_string(0, j, "Temps attente opérateur", writer.add_format({'text_wrap': True}))
                    worksheet.set_column(j, j, 18)
                    j += 1

                    worksheet.write_string(0, j, "Temps de cycle total", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps de cycle propre", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Temps de cycle panne", writer.add_format({'text_wrap': True}))
                    j += 1

                    worksheet.write_string(0, j, "Taux de disponibilité", writer.add_format({'text_wrap': True}))
                    j += 1

                    for k in range(1, 34):
                        worksheet.max_column_widths[k] = 14

                    start = datetime.strptime(v_date_debut, "%Y-%m-%d")
                    end = datetime.strptime(v_date_fin, "%Y-%m-%d")
                    date_generated = [start + timedelta(days=x) for x in range(0, (end-start).days+1)]

                    for date in date_generated:
                        print(date)

                        date_debut = date.strftime("%Y-%m-%d")
                        date_fin = date + timedelta(days=1)
                        date_fin = date_fin.strftime("%Y-%m-%d")
                        print(date_fin)

                        API_Nbr_de_Pilulier_Med = 0
                        API_Nbr_de_Plateau_Med = 0

                        API_Nbr_Carnet_Pilulier_Med = 0
                        API_Nbr_de_Plateau_Carnet_Med = 0

                        API_Nbr_de_Pilulier_Carnet_Med = 0

                        API_Nbr_Blister_Charge_Med = 0
                        API_Nbr_Goulotte_Chargee_Med = 0
                        API_Nbr_Erreur_Goulotte_Med = 0
                        API_Nbr_Blister_pris_Med = 0
                        API_Nbr_Sachet_Pose_Med = 0
                        API_Nbr_SachetP_Pose_Med = 0
                        API_Nbr_DU_Pose_Med = 0
                        API_Nbr_Ticket_Pose_Med = 0
                        API_Nbr_Sachet_Pose_Carnet_Med = 0
                        API_Nbr_SachetP_Pose_Carnet_Med = 0
                        API_Nbr_Du_Pose_Carnet_Med = 0
                        API_Nbr_Ticket_Pose_Carnet_Med = 0
                        API_Temps_Chgt_Blister_Med = 0
                        API_Temps_Dchgt_Plateau_Med = 0
                        API_Temps_Cueil_Pil_Med = 0
                        API_Temps_Cueil_Carnet_Med = 0
                        API_Nbr_Dose_Rangee_Med = 0
                        API_Nbr_Dose_Rangee_Heure_Med = 0

                        API_TEMPS_ATTENTE_OPERATEUR_Med = 0
                        API_TEMPS_ATTENTE_ECRAN_Med = 0
                        API_TEMPS_RESOLUTION_DEFAUT_Med = 0
                        API_TEMPS_UTILISATION_Med = 0
                        API_TEMPS_CYCLE_REEL_Med = 0
                        API_DISPONIBILITE_Med = 0

                        API_Nbr_de_Pilulier_heure_Med = 0
                        API_Nbr_de_Pilulier_Carnet_heure_Med = 0

                        Nb_doses_Pilulier = 0
                        Nb_doses_Carnet = 0

                        # date_fin = datetime.strptime(v_date_fin, "%Y-%m-%d") + timedelta(days=1)

                        subquery = (SuiviProd.select(SuiviProd.variable.alias('variable'),
                                    fn.MAX(SuiviProd.pk).alias('max_pk'))
                                    .where(
                                        (SuiviProd.poste == row.type_mag) &
                                        (SuiviProd.chrono >= date_debut) &
                                        (SuiviProd.chrono < date_fin))
                                    .group_by(SuiviProd.variable, SuiviProd.chrono))

                        compteur = (SuiviProd
                                    .select(SuiviProd.pk, SuiviProd.variable, SuiviProd.valeur_num,
                                            SuiviProd.valeur_alpha)
                                    .join(subquery, on=((subquery.c.max_pk == SuiviProd.pk) &
                                          (subquery.c.variable == SuiviProd.variable))))

                        for var in compteur:
                            if var.variable == "API_Nbr_de_Pilulier_Med":
                                API_Nbr_de_Pilulier_Med = var.valeur_num
                            elif var.variable == "API_Nbr_de_Plateau_Med":
                                API_Nbr_de_Plateau_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Carnet_Pilulier_Med":
                                API_Nbr_Carnet_Pilulier_Med = var.valeur_num
                            elif var.variable == "API_Nbr_de_Plateau_Carnet_Med":
                                API_Nbr_de_Plateau_Carnet_Med = var.valeur_num
                            elif var.variable == "API_Nbr_de_Pilulier_Carnet_Med":
                                API_Nbr_de_Pilulier_Carnet_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Blister_Charge_Med":
                                API_Nbr_Blister_Charge_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Goulotte_Chargee_Med":
                                API_Nbr_Goulotte_Chargee_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Erreur_Goulotte_Med":
                                API_Nbr_Erreur_Goulotte_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Blister_pris_Med":
                                API_Nbr_Blister_pris_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Sachet_Pose_Med":
                                API_Nbr_Sachet_Pose_Med = var.valeur_num
                            elif var.variable == "API_Nbr_SachetP_Pose_Med":
                                API_Nbr_SachetP_Pose_Med = var.valeur_num
                            elif var.variable == "API_Nbr_DU_Pose_Med":
                                API_Nbr_DU_Pose_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Ticket_Pose_Med":
                                API_Nbr_Ticket_Pose_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Sachet_Pose_Carnet_Med":
                                API_Nbr_Sachet_Pose_Carnet_Med = var.valeur_num
                            elif var.variable == "API_Nbr_SachetP_Pose_Carnet_Med":
                                API_Nbr_SachetP_Pose_Carnet_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Du_Pose_Carnet_Med":
                                API_Nbr_Du_Pose_Carnet_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Ticket_Pose_Carnet_Med":
                                API_Nbr_Ticket_Pose_Carnet_Med = var.valeur_num
                            elif var.variable == "API_Temps_Chgt_Blister_Med":
                                time = var.valeur_num
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_Temps_Chgt_Blister_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_Temps_Dchgt_Plateau_Med":
                                time = var.valeur_num
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_Temps_Dchgt_Plateau_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_Temps_Cueil_Pil_Med":
                                time = var.valeur_num
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_Temps_Cueil_Pil_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_Temps_Cueil_Carnet_Med":
                                time = var.valeur_num
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_Temps_Cueil_Carnet_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_Nbr_Dose_Rangee_Med":
                                API_Nbr_Dose_Rangee_Med = var.valeur_num
                            elif var.variable == "API_Nbr_Dose_Rangee_Heure_Med":
                                API_Nbr_Dose_Rangee_Heure_Med = var.valeur_num
                            elif var.variable == "API_TEMPS_ATTENTE_OPERATEUR_Med":
                                time = var.valeur_num/3600
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_TEMPS_ATTENTE_OPERATEUR_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_TEMPS_ATTENTE_ECRAN_Med":
                                time = var.valeur_num/3600
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_TEMPS_ATTENTE_ECRAN_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_TEMPS_RESOLUTION_DEFAUT_Med":
                                time = var.valeur_num/3600
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_TEMPS_RESOLUTION_DEFAUT_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_TEMPS_UTILISATION_Med":
                                time = var.valeur_num/3600
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_TEMPS_UTILISATION_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_TEMPS_CYCLE_REEL_Med":
                                time = var.valeur_num/3600
                                hours = int(time)
                                minutes = (time*60) % 60.
                                seconds = (time*3600) % 60.
                                API_TEMPS_CYCLE_REEL_Med = "%02d:%02d:%02d" % (hours, minutes, seconds)
                            elif var.variable == "API_DISPONIBILITE_Med":
                                API_DISPONIBILITE_Med = var.valeur_num
                            elif var.variable == "API_Nbr_de_Pilulier_heure_Med":
                                API_Nbr_de_Pilulier_heure_Med = round(var.valeur_num, 2)
                            elif var.variable == "API_Nbr_Carnet_Pilulier_heure_Med":
                                API_Nbr_de_Pilulier_Carnet_heure_Med = round(var.valeur_num, 2)

                        if API_Nbr_de_Pilulier_Med != 0:
                            Nb_doses_Pilulier = ((API_Nbr_DU_Pose_Med+API_Nbr_Sachet_Pose_Med+API_Nbr_SachetP_Pose_Med)
                                                 / API_Nbr_de_Pilulier_Med)
                            Nb_doses_Pilulier = round(Nb_doses_Pilulier, 2)
                        else:
                            Nb_doses_Pilulier = 0

                        if API_Nbr_Carnet_Pilulier_Med != 0:
                            Nb_doses_Carnet = ((API_Nbr_Sachet_Pose_Carnet_Med+API_Nbr_SachetP_Pose_Carnet_Med
                                                + API_Nbr_Du_Pose_Carnet_Med)/API_Nbr_Carnet_Pilulier_Med)
                            Nb_doses_Carnet = round(Nb_doses_Carnet, 2)
                        else:
                            Nb_doses_Carnet = 0

                        i += 1
                        j = 0

                        worksheet.write_datetime(i, j, datetime.strptime(date_debut, "%Y-%m-%d"), format_court)
                        j += 1

                        worksheet.write(i, j, API_Nbr_de_Pilulier_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_de_Plateau_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_DU_Pose_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Sachet_Pose_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_SachetP_Pose_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Ticket_Pose_Med)
                        j += 1

                        worksheet.write(i, j, API_Temps_Cueil_Pil_Med)
                        j += 1

                        worksheet.write(i, j, Nb_doses_Pilulier)
                        j += 1

                        worksheet.write(i, j, API_Nbr_de_Pilulier_heure_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Carnet_Pilulier_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_de_Plateau_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_de_Pilulier_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Du_Pose_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Sachet_Pose_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_SachetP_Pose_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Ticket_Pose_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, API_Temps_Cueil_Carnet_Med)
                        j += 1

                        worksheet.write(i, j, Nb_doses_Carnet)
                        j += 1

                        worksheet.write(i, j, API_Nbr_de_Pilulier_Carnet_heure_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Blister_Charge_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Goulotte_Chargee_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Erreur_Goulotte_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Blister_pris_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Dose_Rangee_Med)
                        j += 1

                        worksheet.write(i, j, API_Nbr_Dose_Rangee_Heure_Med)
                        j += 1

                        worksheet.write(i, j, API_Temps_Chgt_Blister_Med)
                        j += 1

                        worksheet.write(i, j, API_Temps_Dchgt_Plateau_Med)
                        j += 1

                        worksheet.write(i, j, API_TEMPS_ATTENTE_ECRAN_Med)
                        j += 1

                        worksheet.write(i, j, API_TEMPS_ATTENTE_OPERATEUR_Med)
                        j += 1

                        worksheet.write(i, j, API_TEMPS_UTILISATION_Med)
                        j += 1

                        worksheet.write(i, j, API_TEMPS_CYCLE_REEL_Med)
                        j += 1

                        worksheet.write(i, j, API_TEMPS_RESOLUTION_DEFAUT_Med)
                        j += 1

                        worksheet.write(i, j, API_DISPONIBILITE_Med)
                        j += 1

                        for column, width in worksheet.max_column_widths.items():
                            worksheet.set_column(column, column, width)

            writer.close()
            # proxy.close()

            logger.info('Export compteurs 2: ' + str(name))

            return send_file(os.sep.join(
                [os.getcwd(), "tmp_export", "%s.xlsx" % name]),
                as_attachment=True, attachment_filename='download_filename.xlsx')
        except Exception as error:
            logger.error('Export compteurs raised an exception: ', error.args)


def excel_string_width(str, j, worksheet):
    """
    Calculate the length of the string in Excel character units. This is only
    an example and won't give accurate results. It will need to be replaced
    by something more rigorous.

    """

    min_width = 0

    # Check if it the string is the largest we have seen for this column.

    string_width = len(str)

    if string_width > min_width:
        max_width = worksheet.max_column_widths.get(j, min_width)
        if string_width > max_width:
            worksheet.max_column_widths[j] = string_width * 1.1
