from flask_restful import Resource
from median.models import Adresse, Compteur
import logging

logger = logging.getLogger('median.webserver')


class ApiAdresse(Resource):

    def get(self, mag, format):
        try:

            _f = self.ecoBasicDecodeURIComponent(format)

            adr = (Adresse.select()
                   .where((Adresse.format == _f) & (Adresse.magasin == mag))
                   .order_by(Adresse.adresse))

            logger.info('Lines : %s.' % len(adr))

        except Exception as error:
            logger.error('Exception levée en cherchant des adresses, '
                         'format: "%s", magasin: "%s". Message d\'erreur: "%s"' % (format, mag, error.args))
            return {'message': error.args}, 503

        if not len(adr):
            logger.warning('Adresses non trouvées, format: "%s", magasin: "%s"' % (format, mag))

        return ([{
            'adresse': a.adresse,
            'etat': a.etat,
            'contenant': a.contenant
        } for a in adr])

    def post(self, adr):

        logger.info('Chercher le code contenant d\'une adresse: "%s"' % (adr))
        _ex_cont = Adresse.get(Adresse.adresse == adr).contenant
        if _ex_cont != '':
            logger.info('Code contenant de l\' adresse "%s": "%s"' % (adr, _ex_cont))
            return _ex_cont
        else:
            _cur_counter = Compteur.get(Compteur.cle == 'CONTENANT_PASS')
            _new_counter = _cur_counter.val + 1

            logger.info('Mise à jour du compteur code contenant, adresse: "%s", '
                        'valeur du compteur: "%s"' % (adr, _new_counter))
            q = Compteur.update({Compteur.val: _new_counter}).where(Compteur.cle == 'CONTENANT_PASS')
            q.execute()

            logger.info('Code contenant de l\' adresse "%s": "%s"' % (adr, str(_new_counter).rjust(9, '0')))
            return str(_new_counter).rjust(9, '0')

    def ecoBasicDecodeURIComponent(self, str):
        return str.replace('__', ' ').replace('--', '/')
