from peewee import (
    AutoField,
    CharField,
)
from peewee import SQL
from ..base import WebModel


class WebLang(WebModel):

    pk = AutoField(
        column_name='id', primary_key=True)
    code = CharField(
        column_name='code', max_length=16)
    name = CharField(
        column_name='name', max_length=64)
    date_format = CharField(
        column_name='date_fmt', max_length=64, null=True)
    direction = CharField(
        column_name='direction', max_length=3, constraints=[SQL("DEFAULT 'ltr'")])
    thousands_separator = CharField(
        column_name='thousands_sep', max_length=16, constraints=[SQL("DEFAULT ' '")])
    decimal_point = CharField(
        column_name='decimal_point', max_length=16, constraints=[SQL("DEFAULT ' '")])
    time_format = CharField(
        column_name='time_fmt', max_length=64, null=True)
    iso_639_code = CharField(
        column_name='iso_639_code', max_length=3, null=True)
    iso_3166_code = CharField(
        column_name='iso_3166_code', max_length=3, null=True)

    class Meta:
        table_name = 'web_lang'
        indexes = (
            (('code',), True),
            (('name',), False),
        )
