from median.models import Label, Rights, Config
from peewee import DoesNotExist

INTERFACES_KEYS = [
    'k_ping', 'k_drugs', 'k_patient', 'k_episode', 'k_service',
    'k_dispensation', 'k_prescription', 'k_stock_in', 'k_stock_out', 'k_stock_delta',
    'k_stock_level',
]


def add_default_libelle():
    """Add default libelle"""
    lb, created = Label.get_or_create(code="ref_dci", libelle="DCI")
    lb, created = Label.get_or_create(code="ref_desig_bis", libelle="Desig bis")


def add_default_rights():
    rg, created = Rights.get_or_create(ressource='WEB_PRODUIT', libelle="MedianWeb\\Produit")
    rg, created = Rights.get_or_create(ressource='WEB_ACCED', libelle="MedianWeb\\Acced")
    rg, created = Rights.get_or_create(ressource='WEB_PRODUIT_PARAM', libelle="MedianWeb\\Param produit")
    rg, created = Rights.get_or_create(ressource='WEB_PRODUIT_BATCH', libelle="MedianWeb\\Lot produit")
    rg, created = Rights.get_or_create(ressource='WEB_DASHBOARD', libelle="MedianWeb\\Tableaude bord")
    rg, created = Rights.get_or_create(ressource='WEB_REAPPRO', libelle="MedianWeb\\Reappro")
    rg, created = Rights.get_or_create(ressource='WEB_HISTORY', libelle="MedianWeb\\Historique")
    rg, created = Rights.get_or_create(ressource='WEB_DISPENSATION', libelle="MedianWeb\\Dispensation")
    rg, created = Rights.get_or_create(ressource='WEB_LOCATIONS', libelle="MedianWeb\\Emplacements")
    rg, created = Rights.get_or_create(ressource='WEB_PARAMETER', libelle="MedianWeb\\Paramètres")
    rg, created = Rights.get_or_create(ressource='WEB_USERS', libelle="MedianWeb\\Utilisateurs")
    rg, created = Rights.get_or_create(ressource='WEB_DASHBOARD_STATS', libelle="MedianWeb\\Statistiques")
    rg, created = Rights.get_or_create(ressource='WEB_DASHBOARD_COMPTEUR', libelle="MedianWeb\\Compteur")
    rg, created = Rights.get_or_create(ressource='WEB_SERVICES', libelle="MedianWeb\\Services")
    rg, created = Rights.get_or_create(ressource='WEB_RIEDL', libelle="MedianWeb\\Riedl")
    rg, created = Rights.get_or_create(ressource='WEB_RIEDL_INPUT', libelle="MedianWeb\\Entréee Riedl")
    rg, created = Rights.get_or_create(ressource='WEB_RIEDL_OUTPUT', libelle="MedianWeb\\Sorties Riedl")
    rg, created = Rights.get_or_create(ressource='WEB_ASTUS', libelle="MedianWeb\\Astus")


def add_default_interfaces():
    """Add keys for interfaces ports"""
    i = 0
    for k in INTERFACES_KEYS:
        addr = k
        try:
            Config.get(poste='TOUS', cle='interface', propriete=addr)
            print('Interface %s key exists' % addr)
        except DoesNotExist:
            zpl_cfg = Config()
            zpl_cfg.ref_id = '_INTREF0%i' % (i + 1)
            zpl_cfg.poste = 'TOUS'
            zpl_cfg.cle = 'interface'
            zpl_cfg.propriete = addr
            zpl_cfg.type_value = 'C'
            zpl_cfg.value = 'Z'
            zpl_cfg.hierarchie_menu = """Interface\\ Etat %s""" % (k,)
            zpl_cfg.type_champ = 'reg'
            zpl_cfg.ordre = 10 + i
            zpl_cfg.save()
            print('Interface %s created' % addr)
        i += 1

        addr = k + "_date"
        try:
            Config.get(poste='TOUS', cle='interface', propriete=addr)
            print('Interface %s key exists' % addr)
        except DoesNotExist:
            zpl_cfg = Config()
            zpl_cfg.ref_id = '_INTREF0%i' % (i + 1)
            zpl_cfg.poste = 'TOUS'
            zpl_cfg.cle = 'interface'
            zpl_cfg.propriete = addr
            zpl_cfg.type_value = 'C'
            zpl_cfg.value = '0000-00-00 00:00:00'
            zpl_cfg.hierarchie_menu = """Interface\\Date %s""" % (k,)
            zpl_cfg.type_champ = 'reg'
            zpl_cfg.ordre = 10 + i
            zpl_cfg.save()
            print('Interface %s created' % addr)

        i += 1
