# Use by command flask fix
from median.database import mysql_db
import logging

logger = logging.getLogger('median.webserver')


def fix_foreign_key():
    """Delete and recreate the foreign key"""
    logger.info("Recreate all foreign key")
    execute_ddl_query("ALTER TABLE web_menu_i18n DROP FOREIGN KEY web_menu_i18n_ibfk_2;")
    execute_ddl_query("ALTER TABLE web_menu_i18n ADD CONSTRAINT web_menu_i18n_ibfk_2 FOREIGN KEY (lang_id) REFERENCES web_lang(id) ON DELETE CASCADE ON UPDATE CASCADE;")  # noqa
    execute_ddl_query("ALTER TABLE web_menu_i18n DROP FOREIGN KEY web_menu_i18n_ibfk_1;")
    execute_ddl_query("ALTER TABLE web_menu_i18n ADD CONSTRAINT web_menu_i18n_ibfk_1 FOREIGN KEY (menu_id) REFERENCES web_menu(id) ON DELETE CASCADE;")  # noqa
    execute_ddl_query("ALTER TABLE web_menu DROP FOREIGN KEY web_menu_ibfk_1;")
    execute_ddl_query("ALTER TABLE web_menu ADD CONSTRAINT web_menu_ibfk_1 FOREIGN KEY (parent_id) REFERENCES web_menu(id) ON DELETE CASCADE ON UPDATE CASCADE;")  # noqa
    execute_ddl_query("ALTER TABLE web_form_i18n DROP FOREIGN KEY web_form_i18n_ibfk_1;")
    execute_ddl_query("ALTER TABLE web_form_i18n ADD CONSTRAINT web_form_i18n_ibfk_1 FOREIGN KEY (lang_id) REFERENCES web_lang(id) ON DELETE CASCADE ON UPDATE CASCADE;")  # noqa


def fix_datas():
    """Fix inconsistent datas"""
    execute_ddl_query("UPDATE f_profil SET x_visu=1 WHERE x_visu IS NULL;")
    execute_ddl_query("UPDATE f_profil SET x_edit=0 WHERE x_edit IS NULL;")
    execute_ddl_query("UPDATE f_mag SET x_libelle=x_type_mag WHERE x_libelle = '';")


def execute_ddl_query(query):
    """Execute a SQL query"""
    mysql_db.execute_sql(query)
